/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.handler;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.visualworkbench.handler.BlockConversionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockModelHandler {
    private static final Supplier<Map<ResourceLocation, ResourceLocation>> MODEL_LOCATIONS = Suppliers.memoize(() -> (Map)BlockConversionHandler.BLOCK_CONVERSIONS.inverse().entrySet().stream().flatMap(entry -> BlockModelHandler.convertAllBlockStates((Block)entry.getKey(), (Block)entry.getValue()).entrySet().stream()).collect(Util.m_137448_()));

    public static void onLoadComplete() {
        for (Map.Entry entry : BlockConversionHandler.BLOCK_CONVERSIONS.entrySet()) {
            RenderType renderType = ClientAbstractions.INSTANCE.getRenderType((Block)entry.getKey());
            ClientAbstractions.INSTANCE.registerRenderType((Block)entry.getValue(), renderType);
        }
    }

    public static EventResultHolder<UnbakedModel> onModifyUnbakedModel(ResourceLocation modelLocation, Supplier<UnbakedModel> unbakedModel, Function<ResourceLocation, UnbakedModel> modelGetter, BiConsumer<ResourceLocation, UnbakedModel> modelAdder) {
        if (MODEL_LOCATIONS.get().containsKey(modelLocation)) {
            return EventResultHolder.interrupt((Object)modelGetter.apply(MODEL_LOCATIONS.get().get(modelLocation)));
        }
        return EventResultHolder.pass();
    }

    private static Map<ModelResourceLocation, ModelResourceLocation> convertAllBlockStates(Block oldBlock, Block newBlock) {
        HashMap modelLocations = Maps.newHashMap();
        for (BlockState oldBlockState : oldBlock.m_49965_().m_61056_()) {
            BlockState newBlockState = BlockModelHandler.convertBlockState((StateDefinition<Block, BlockState>)newBlock.m_49965_(), oldBlockState);
            modelLocations.put(BlockModelShaper.m_110895_((BlockState)oldBlockState), BlockModelShaper.m_110895_((BlockState)newBlockState));
        }
        return modelLocations;
    }

    private static BlockState convertBlockState(StateDefinition<Block, BlockState> newStateDefinition, BlockState oldBlockState) {
        BlockState newBlockState = (BlockState)newStateDefinition.m_61090_();
        for (Map.Entry entry : oldBlockState.m_61148_().entrySet()) {
            newBlockState = BlockModelHandler.setBlockStateValue((Property)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.m_61081_(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private static <T extends Comparable<T>, V extends T> BlockState setBlockStateValue(Property<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable Property<?>> propertyGetter, BlockState blockState) {
        Property<?> newProperty = propertyGetter.apply(oldProperty.m_61708_());
        if (newProperty != null) {
            return (BlockState)blockState.m_61124_(newProperty, oldValue);
        }
        return blockState;
    }
}

