/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.networking;

import com.epherical.epherolib.networking.AbstractNetworking;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgeNetworking
extends AbstractNetworking<CustomPayloadEvent.Context, CustomPayloadEvent.Context> {
    private static int id = 0;
    public final SimpleChannel INSTANCE;
    private final ResourceLocation modChannel;
    private final String version;

    public ForgeNetworking(ResourceLocation location, String version, Predicate<String> clientAcceptedVersion, Predicate<String> serverAcceptedVersion) {
        this.modChannel = location;
        this.version = version;
        this.INSTANCE = ChannelBuilder.named((ResourceLocation)location).simpleChannel();
    }

    @Override
    public <MSG> void registerServerToClient(int id, Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, AbstractNetworking.Context<CustomPayloadEvent.Context>> consumer) {
        this.INSTANCE.messageBuilder(type, id).encoder(encoder).decoder(decoder).consumerNetworkThread((msg, context) -> {
            context.getSender();
            AbstractNetworking.Side side = context.getDirection().getReceptionSide().isServer() ? AbstractNetworking.Side.SERVER : AbstractNetworking.Side.CLIENT;
            consumer.accept(msg, new AbstractNetworking.Context(side, context.getSender()));
        }).add();
    }

    @Override
    public <T> void registerClientToServer(int id, Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, AbstractNetworking.Context<CustomPayloadEvent.Context>> consumer) {
        this.INSTANCE.messageBuilder(type, id).encoder(encoder).decoder(decoder).consumerNetworkThread((t, context) -> {
            AbstractNetworking.Side side = context.getDirection().getReceptionSide().isServer() ? AbstractNetworking.Side.SERVER : AbstractNetworking.Side.CLIENT;
            consumer.accept(t, new AbstractNetworking.Context(side, context.getSender()));
        });
    }

    @Override
    public <T> void sendToClient(T type, ServerPlayer serverPlayer) {
        this.INSTANCE.send(type, PacketDistributor.PLAYER.with((Object)serverPlayer));
    }

    @Override
    public <T> void sendToServer(T type, Connection connection) {
        this.INSTANCE.send(type, connection);
    }
}

