/*
 * Decompiled with CFR 0.152.
 */
package net.lostluma.dynamic_fps.impl.forge.service;

import dynamic_fps.impl.service.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.lostluma.dynamic_fps.impl.forge.DynamicFPSForgeMod;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgePlatform
implements Platform {
    @Override
    public String getName() {
        return "Forge";
    }

    @Override
    public Path getCacheDir() {
        Path base = FMLPaths.GAMEDIR.get();
        return this.ensureDir(base.resolve(".cache").resolve("dynamic_fps"));
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Optional<String> getModVersion(String modId) {
        Optional optional = ModList.get().getModContainerById(modId);
        return optional.map(modContainer -> modContainer.getModInfo().getVersion().toString());
    }

    @Override
    public void registerStartTickEvent(Platform.StartTickEvent event) {
        DynamicFPSForgeMod.addTickEventListener(event);
    }

    private Path ensureDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Dynamic FPS directory.", e);
        }
        return path;
    }
}

