/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={DebugScreenOverlay.class})
public class DebugScreenOverlayMixin {
    @ModifyReturnValue(method={"getGameInformation"}, at={@At(value="RETURN")})
    private List<String> getGameInformation(List<String> result) {
        if (DynamicFPSMod.isDisabled()) {
            String reason = DynamicFPSMod.whyIsTheModNotWorking();
            result.add(2, this.format("\u00a7c[Dynamic FPS] Inactive! Reason: %s\u00a7r", reason));
        } else {
            PowerState status = DynamicFPSMod.powerState();
            if (status != PowerState.FOCUSED) {
                int target = DynamicFPSMod.targetFrameRate();
                result.add(2, this.format("\u00a7c[Dynamic FPS] FPS: %s P: %s\u00a7r", target, status.toString().toLowerCase()));
            }
        }
        return result;
    }

    private String format(String template, Object ... args) {
        return String.format(Locale.ROOT, template, args);
    }
}

