/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Logging;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Serialization {
    private static final Gson GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().enableComplexMapKeySerialization().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(PowerState.class, (Object)new PowerStateSerializer()).registerTypeAdapter(GraphicsState.class, (Object)new GraphicsStateSerializer()).create();
    private static final String CONFIG_FILE = "dynamic_fps.json";

    public static void save(DynamicFPSConfig instance) {
        String data = GSON.toJson((Object)instance) + "\n";
        Path cache = Platform.getInstance().getCacheDir();
        Path config = Platform.getInstance().getConfigDir().resolve(CONFIG_FILE);
        try {
            Path temp = Files.createTempFile(cache, "config", ".json", new FileAttribute[0]);
            Files.write(temp, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Serialization.move(temp, config);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save or modify Dynamic FPS config!", e);
        }
    }

    private static void move(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException | UnsupportedOperationException e) {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static DynamicFPSConfig load() {
        byte[] data;
        Path config = Platform.getInstance().getConfigDir().resolve(CONFIG_FILE);
        try {
            data = Files.readAllBytes(config);
        }
        catch (NoSuchFileException e) {
            return DynamicFPSConfig.createDefault();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Dynamic FPS config.", e);
        }
        if (data[0] == 0) {
            Logging.getLogger().warn("Dynamic FPS config corrupted! Recreating from defaults ...");
            return DynamicFPSConfig.createDefault();
        }
        JsonElement root = new JsonParser().parse(new String(data, StandardCharsets.UTF_8));
        Serialization.upgradeConfig((JsonObject)root);
        return (DynamicFPSConfig)GSON.fromJson(root, DynamicFPSConfig.class);
    }

    private static void upgradeConfig(JsonObject root) {
        Serialization.addIdleTime(root);
        Serialization.upgradeVolumeMultiplier(root);
        Serialization.addAbandonedConfig(root);
        Serialization.addUncapMenuFrameRate(root);
        Serialization.addEnabled(root);
    }

    private static void addIdleTime(JsonObject root) {
        if (!root.has("idle_time")) {
            root.addProperty("idle_time", (Number)0);
        }
    }

    private static void upgradeVolumeMultiplier(JsonObject root) {
        JsonObject states = Serialization.getStatesAsObject(root);
        if (states == null) {
            return;
        }
        for (Map.Entry entry : states.entrySet()) {
            JsonElement multiplier;
            JsonObject element;
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonObject() || !(element = value.getAsJsonObject()).has("volume_multiplier") || !(multiplier = element.get("volume_multiplier")).isJsonPrimitive() || !((JsonPrimitive)multiplier).isNumber()) continue;
            JsonObject multipliers = new JsonObject();
            multipliers.add("master", multiplier);
            element.add("volume_multipliers", (JsonElement)multipliers);
        }
    }

    private static void addAbandonedConfig(JsonObject root) {
        JsonObject states = Serialization.getStatesAsObject(root);
        if (states == null) {
            return;
        }
        if (states.has("abandoned")) {
            return;
        }
        states.add("abandoned", GSON.toJsonTree((Object)Config.getDefault(PowerState.ABANDONED)));
    }

    private static void addUncapMenuFrameRate(JsonObject root) {
        if (!root.has("uncap_menu_frame_rate")) {
            root.addProperty("uncap_menu_frame_rate", Boolean.valueOf(false));
        }
    }

    private static void addEnabled(JsonObject root) {
        if (!root.has("enabled")) {
            root.addProperty("enabled", Boolean.valueOf(true));
        }
    }

    @Nullable
    private static JsonObject getStatesAsObject(JsonObject root) {
        if (!root.has("states")) {
            return null;
        }
        if (!root.get("states").isJsonObject()) {
            return null;
        }
        return root.getAsJsonObject("states");
    }

    private static final class PowerStateSerializer
    implements JsonSerializer<PowerState>,
    JsonDeserializer<PowerState> {
        private PowerStateSerializer() {
        }

        public JsonElement serialize(PowerState state, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(state.toString().toLowerCase(Locale.ROOT));
        }

        public PowerState deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return PowerState.valueOf(element.getAsString().toUpperCase(Locale.ROOT));
        }
    }

    private static final class GraphicsStateSerializer
    implements JsonSerializer<GraphicsState>,
    JsonDeserializer<GraphicsState> {
        private GraphicsStateSerializer() {
        }

        public JsonElement serialize(GraphicsState state, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(state.toString().toLowerCase(Locale.ROOT));
        }

        public GraphicsState deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return GraphicsState.valueOf(element.getAsString().toUpperCase(Locale.ROOT));
        }
    }
}

