/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.annotations.SerializedName;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.Serialization;
import java.util.EnumMap;
import java.util.Map;

public final class DynamicFPSConfig {
    private boolean enabled;
    private int idleTime;
    private boolean uncapMenuFrameRate;
    @SerializedName(value="states")
    private final Map<PowerState, Config> configs;

    private DynamicFPSConfig(boolean enabled, int abandonTime, boolean uncapMenuFrameRate, Map<PowerState, Config> configs) {
        this.enabled = enabled;
        this.idleTime = abandonTime;
        this.uncapMenuFrameRate = uncapMenuFrameRate;
        this.configs = new EnumMap<PowerState, Config>(configs);
        for (PowerState state : PowerState.values()) {
            if (!state.configurable) continue;
            this.configs.computeIfAbsent(state, Config::getDefault);
        }
    }

    public static DynamicFPSConfig createDefault() {
        DynamicFPSConfig instance = new DynamicFPSConfig(true, 0, false, new EnumMap<PowerState, Config>(PowerState.class));
        instance.save();
        return instance;
    }

    public Config get(PowerState state) {
        if (state == PowerState.FOCUSED) {
            return Config.ACTIVE;
        }
        return this.configs.get((Object)state);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public int idleTime() {
        return this.idleTime;
    }

    public void setIdleTime(int value) {
        this.idleTime = value;
    }

    public boolean uncapMenuFrameRate() {
        return this.uncapMenuFrameRate;
    }

    public void setUncapMenuFrameRate(boolean value) {
        this.uncapMenuFrameRate = value;
    }

    private Map<PowerState, Config> configs() {
        return this.configs;
    }

    public static DynamicFPSConfig load() {
        return Serialization.load();
    }

    public void save() {
        Serialization.save(this);
    }
}

