/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.compat;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.util.Localization;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;

public final class ClothConfig {
    public static Screen genConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Localization.localized("config", "title", new Object[0])).setSavingRunnable(DynamicFPSMod::onConfigChanged);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Localization.localized("config", "category.general", new Object[0]));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Localization.localized("config", "enabled", new Object[0]), DynamicFPSMod.modConfig.enabled()).setDefaultValue(true).setSaveConsumer(DynamicFPSMod.modConfig::setEnabled).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(CommonComponents.f_263701_).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Localization.localized("config", "idle_time", new Object[0]), DynamicFPSMod.modConfig.idleTime() / 60, 0, 30).setDefaultValue(0).setSaveConsumer(value -> DynamicFPSMod.modConfig.setIdleTime(value * 60)).setTextGetter(ClothConfig::idleTimeMessage).setTooltip(new Component[]{Localization.localized("config", "idle_time_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Localization.localized("config", "uncap_menu_frame_rate", new Object[0]), DynamicFPSMod.modConfig.uncapMenuFrameRate()).setDefaultValue(false).setSaveConsumer(DynamicFPSMod.modConfig::setUncapMenuFrameRate).setTooltip(new Component[]{Localization.localized("config", "uncap_menu_frame_rate_tooltip", new Object[0])}).build());
        for (PowerState state : PowerState.values()) {
            if (!state.configurable) continue;
            Config config = DynamicFPSMod.modConfig.get(state);
            Config standard = Config.getDefault(state);
            ConfigCategory category = builder.getOrCreateCategory((Component)Localization.localized("config", "category." + state.toString().toLowerCase(), new Object[0]));
            category.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Localization.localized("config", "frame_rate_target", new Object[0]), ClothConfig.fromConfigFpsTarget(config.frameRateTarget()), 0, 61).setDefaultValue(ClothConfig.fromConfigFpsTarget(standard.frameRateTarget())).setSaveConsumer(value -> config.setFrameRateTarget(ClothConfig.toConfigFpsTarget(value))).setTextGetter(ClothConfig::fpsTargetMessage).build());
            SubCategoryBuilder volumes = entryBuilder.startSubCategory((Component)Localization.localized("config", "volume_multiplier", new Object[0]));
            for (SoundSource source : SoundSource.values()) {
                String name = source.m_12676_();
                volumes.add((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)("soundCategory." + name)), (int)(config.rawVolumeMultiplier(source) * 100.0f), 0, 100).setDefaultValue((int)(standard.rawVolumeMultiplier(source) * 100.0f)).setSaveConsumer(value -> config.setVolumeMultiplier(source, (float)value.intValue() / 100.0f)).setTextGetter(ClothConfig::volumeMultiplierMessage).build());
            }
            category.addEntry((AbstractConfigListEntry)volumes.build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Localization.localized("config", "graphics_state", new Object[0]), GraphicsState.class, (Enum)config.graphicsState()).setDefaultValue((Enum)standard.graphicsState()).setSaveConsumer(config::setGraphicsState).setEnumNameProvider(ClothConfig::graphicsStateMessage).setTooltipSupplier(ClothConfig::graphicsStateTooltip).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Localization.localized("config", "show_toasts", new Object[0]), config.showToasts()).setDefaultValue(standard.showToasts()).setSaveConsumer(config::setShowToasts).setTooltip(new Component[]{Localization.localized("config", "show_toasts_tooltip", new Object[0])}).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Localization.localized("config", "run_garbage_collector", new Object[0]), config.runGarbageCollector()).setDefaultValue(standard.runGarbageCollector()).setSaveConsumer(config::setRunGarbageCollector).setTooltip(new Component[]{Localization.localized("config", "run_garbage_collector_tooltip", new Object[0])}).build());
        }
        return builder.build();
    }

    private static Component idleTimeMessage(int value) {
        if (value == 0) {
            return Localization.localized("config", "disabled", new Object[0]);
        }
        return Localization.localized("config", "minutes", value);
    }

    private static int toConfigFpsTarget(int value) {
        return value == 61 ? -1 : value;
    }

    private static int fromConfigFpsTarget(int value) {
        return value == -1 ? 61 : value;
    }

    private static Component fpsTargetMessage(int value) {
        if (ClothConfig.toConfigFpsTarget(value) != -1) {
            return Component.m_237110_((String)"options.framerate", (Object[])new Object[]{value});
        }
        return Component.m_237115_((String)"options.framerateLimit.max");
    }

    private static Component volumeMultiplierMessage(int value) {
        return Component.m_237113_((String)(Integer.toString(value) + "%"));
    }

    private static Component graphicsStateMessage(Enum<GraphicsState> graphicsState) {
        return Localization.localized("config", "graphics_state_" + graphicsState.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    private static Optional<Component[]> graphicsStateTooltip(GraphicsState graphicsState) {
        if (!graphicsState.equals((Object)GraphicsState.MINIMAL)) {
            return Optional.empty();
        }
        return Optional.of(new Component[]{Localization.localized("config", "graphics_state_minimal_tooltip", new Object[0]).m_130940_(ChatFormatting.RED)});
    }
}

