/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl;

import dynamic_fps.impl.Constants;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.compat.GLFW;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.service.ModCompat;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.ModCompatHelper;
import dynamic_fps.impl.util.OptionsHolder;
import dynamic_fps.impl.util.duck.DuckLoadingOverlay;
import dynamic_fps.impl.util.duck.DuckScreen;
import dynamic_fps.impl.util.duck.DuckSoundEngine;
import dynamic_fps.impl.util.event.InputObserver;
import dynamic_fps.impl.util.event.WindowObserver;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class DynamicFPSMod {
    private static Config config = Config.ACTIVE;
    private static PowerState state = PowerState.FOCUSED;
    public static DynamicFPSConfig modConfig = DynamicFPSConfig.load();
    private static boolean isForcingLowFPS = false;
    private static boolean isKeybindDisabled = false;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    private static WindowObserver window;
    @Nullable
    private static InputObserver devices;
    private static long lastRender;
    private static boolean wasIdle;
    private static boolean idleCheckRegistered;
    private static boolean hasRenderedLastFrame;
    private static final boolean OVERLAY_OPTIMIZATION_ACTIVE;

    public static void init() {
        ModCompatHelper.init();
        Platform platform = Platform.getInstance();
        String version = platform.getModVersion("dynamic_fps").orElseThrow();
        Logging.getLogger().info("Dynamic FPS {} active on {}!", (Object)version, (Object)platform.getName());
    }

    public static boolean disabledByUser() {
        return isKeybindDisabled;
    }

    public static WindowObserver getWindow() {
        if (window != null) {
            return window;
        }
        throw new RuntimeException("Accessed window too early!");
    }

    public static boolean isDisabled() {
        return isKeybindDisabled || !modConfig.enabled() || ModCompat.getInstance().isDisabled();
    }

    public static String whyIsTheModNotWorking() {
        ArrayList<String> results = new ArrayList<String>();
        if (isKeybindDisabled) {
            results.add("keybinding");
        }
        if (!modConfig.enabled()) {
            results.add("mod config");
        }
        if (ModCompat.getInstance().isDisabled()) {
            results.add("another mod");
        }
        return String.join((CharSequence)", ", results);
    }

    public static void toggleDisabled() {
        isKeybindDisabled = !isKeybindDisabled;
        DynamicFPSMod.onStatusChanged(true);
    }

    public static void onConfigChanged() {
        modConfig.save();
        DynamicFPSMod.initializeIdleCheck();
    }

    public static void onStatusChanged(boolean userInitiated) {
        if (userInitiated && devices != null) {
            devices.updateLastActionTime();
        }
        DynamicFPSMod.checkForStateChanges();
    }

    public static PowerState powerState() {
        return state;
    }

    public static boolean isForcingLowFPS() {
        return isForcingLowFPS;
    }

    public static void toggleForceLowFPS() {
        isForcingLowFPS = !isForcingLowFPS;
        DynamicFPSMod.onStatusChanged(true);
    }

    public static void setWindow(long address) {
        window = new WindowObserver(address);
        DynamicFPSMod.initializeIdleCheck();
    }

    public static boolean checkForRender() {
        long currentTime = Util.m_137574_();
        long timeSinceLastRender = currentTime - lastRender;
        if (!DynamicFPSMod.checkForRender(timeSinceLastRender)) {
            return false;
        }
        lastRender = currentTime;
        return true;
    }

    public static int targetFrameRate() {
        return config.frameRateTarget();
    }

    public static boolean uncapMenuFrameRate() {
        return modConfig.uncapMenuFrameRate();
    }

    public static float volumeMultiplier(SoundSource source) {
        return config.volumeMultiplier(source);
    }

    public static boolean shouldShowToasts() {
        return config.showToasts();
    }

    public static boolean shouldShowLevels() {
        return DynamicFPSMod.isDisabled() || !DynamicFPSMod.isLevelCoveredByScreen() && !DynamicFPSMod.isLevelCoveredByOverlay();
    }

    private static boolean isLevelCoveredByScreen() {
        return DynamicFPSMod.minecraft.f_91080_ != null && ((DuckScreen)DynamicFPSMod.minecraft.f_91080_).dynamic_fps$rendersBackground();
    }

    private static boolean isIdle() {
        long idleTime = modConfig.idleTime();
        if (idleTime == 0L || devices == null) {
            return false;
        }
        return Util.m_137574_() - devices.lastActionTime() >= idleTime * 1000L;
    }

    private static boolean isLevelCoveredByOverlay() {
        return OVERLAY_OPTIMIZATION_ACTIVE && minecraft.m_91265_() instanceof LoadingOverlay && ((DuckLoadingOverlay)minecraft.m_91265_()).dynamic_fps$isReloadComplete();
    }

    private static void initializeIdleCheck() {
        if (idleCheckRegistered) {
            return;
        }
        if (modConfig.idleTime() == 0 || window == null) {
            return;
        }
        idleCheckRegistered = true;
        devices = new InputObserver(window.address());
        Platform.getInstance().registerStartTickEvent(() -> {
            boolean idle = DynamicFPSMod.isIdle();
            if (idle != wasIdle) {
                wasIdle = idle;
                DynamicFPSMod.onStatusChanged(false);
            }
        });
    }

    public static void handleStateChange(PowerState previous, PowerState current) {
        if (Constants.DEBUG) {
            Logging.getLogger().info("State changed from {} to {}.", (Object)previous, (Object)current);
        }
        Config before = config;
        config = modConfig.get(current);
        GLFW.applyWorkaround();
        hasRenderedLastFrame = false;
        if (config.runGarbageCollector()) {
            System.gc();
        }
        for (SoundSource source : SoundSource.values()) {
            ((DuckSoundEngine)DynamicFPSMod.minecraft.m_91106_().f_120349_).dynamic_fps$updateVolume(before, source);
        }
        if (before.graphicsState() != config.graphicsState()) {
            if (before.graphicsState() == GraphicsState.DEFAULT) {
                OptionsHolder.copyOptions(DynamicFPSMod.minecraft.f_91066_);
            }
            OptionsHolder.applyOptions(DynamicFPSMod.minecraft.f_91066_, config.graphicsState());
        }
    }

    private static void checkForStateChanges() {
        if (window == null) {
            return;
        }
        if (minecraft.m_18695_()) {
            DynamicFPSMod.checkForStateChanges0();
        } else {
            minecraft.m_6937_(DynamicFPSMod::checkForStateChanges0);
        }
    }

    private static void checkForStateChanges0() {
        PowerState current = DynamicFPSMod.isDisabled() ? PowerState.FOCUSED : (isForcingLowFPS ? PowerState.UNFOCUSED : (window.isFocused() ? (!DynamicFPSMod.isIdle() ? PowerState.FOCUSED : PowerState.ABANDONED) : (window.isHovered() ? PowerState.HOVERED : (!window.isIconified() ? PowerState.UNFOCUSED : PowerState.INVISIBLE))));
        if (state != current) {
            PowerState previous = state;
            state = current;
            DynamicFPSMod.handleStateChange(previous, current);
        }
    }

    private static boolean checkForRender(long timeSinceLastRender) {
        int frameRateTarget = config.frameRateTarget();
        if (frameRateTarget <= 0) {
            return frameRateTarget == -1;
        }
        if (!hasRenderedLastFrame) {
            hasRenderedLastFrame = true;
            return true;
        }
        long frameTime = 1000 / frameRateTarget;
        return timeSinceLastRender >= frameTime;
    }

    static {
        wasIdle = false;
        idleCheckRegistered = false;
        hasRenderedLastFrame = false;
        OVERLAY_OPTIMIZATION_ACTIVE = !ModCompat.getInstance().disableOverlayOptimization();
    }
}

