/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.helpers.HungerHelper;

@OnlyIn(value=Dist.CLIENT)
public class DebugInfoHandler {
    private static final DecimalFormat saturationDF = new DecimalFormat("#.##");
    private static final DecimalFormat exhaustionValDF = new DecimalFormat("0.00");
    private static final DecimalFormat exhaustionMaxDF = new DecimalFormat("#.##");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new DebugInfoHandler());
    }

    @SubscribeEvent
    public void onTextRender(CustomizeGuiOverlayEvent.DebugText textEvent) {
        if (!((Boolean)ModConfig.SHOW_FOOD_DEBUG_INFO.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_293199_().m_294516_()) {
            return;
        }
        FoodData stats = mc.f_91074_.m_36324_();
        float curExhaustion = stats.m_150380_();
        float maxExhaustion = HungerHelper.getMaxExhaustion((Player)mc.f_91074_);
        textEvent.getLeft().add("hunger: " + stats.m_38702_() + ", sat: " + saturationDF.format(stats.m_38722_()) + ", exh: " + exhaustionValDF.format(curExhaustion) + "/" + exhaustionMaxDF.format(maxExhaustion));
    }
}

