/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.config.NCRServerPreferences;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.EncryptionButton;
import com.aizistral.nochatreports.common.gui.EncryptionWarningScreen;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import com.aizistral.nochatreports.common.gui.TooltipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen
extends Screen {
    private static final int MESSAGE_MAX_LENGTH = 256;
    private static final ResourceLocation CHAT_STATUS_ICONS = new ResourceLocation("nochatreports", "textures/gui/chat_status_icons_extended.png");
    private static final ResourceLocation ENCRYPTION_BUTTON = new ResourceLocation("nochatreports", "textures/gui/encryption_toggle_button.png");
    private AdvancedImageButton safetyStatusButton;
    @Shadow
    protected EditBox f_95573_;

    protected MixinChatScreen() {
        super(null);
        throw new IllegalStateException("Can't touch this");
    }

    protected void m_264158_(ComponentPath path) {
        if (GUIShenanigans.getLeaf(path).m_264222_() instanceof EditBox) {
            super.m_264158_(path);
        }
    }

    public void m_7522_(GuiEventListener listener) {
        if (listener instanceof EditBox) {
            super.m_7522_(listener);
        }
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String string, boolean bl, CallbackInfoReturnable<Boolean> info) {
        if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.ALWAYS) && !ServerSafetyState.allowChatSigning() && this.f_96541_.m_91403_().m_104910_().m_129535_() && !this.m_232706_(string).isEmpty()) {
            ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
            ServerSafetyState.scheduleSigningAction(NCRClient::resendLastChatMessage);
            ServerSafetyState.setAllowChatSigning(true);
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"normalizeChatMessage"}, at={@At(value="RETURN")}, cancellable=true)
    public void onBeforeMessage(String original, CallbackInfoReturnable<String> info) {
        String message = (String)info.getReturnValue();
        NCRConfig.getEncryption().setLastMessage(message);
        if (!message.isEmpty() && !Screen.m_96637_() && NCRConfig.getEncryption().shouldEncrypt(message)) {
            NCRConfig.getEncryption().getEncryptor().ifPresent(e -> {
                int index = NCRConfig.getEncryption().getEncryptionStartIndex(message);
                String noencrypt = message.substring(0, index);
                String encrypt = message.substring(index, message.length());
                if (encrypt.length() > 0) {
                    int maxEncryptedLength = 256 - noencrypt.length();
                    info.setReturnValue((Object)(noencrypt + this.getEncrypted((Encryptor<?>)e, encrypt, maxEncryptedLength)));
                }
            });
        }
    }

    private String getEncrypted(Encryptor<?> e, String encrypt, int maxLength) {
        while (encrypt.length() > 0) {
            String encrypted = e.encrypt("#%" + encrypt);
            if (encrypted.length() <= maxLength) {
                return encrypted;
            }
            encrypt = encrypt.substring(0, encrypt.length() - 1);
        }
        return "";
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo info) {
        int buttonX = this.f_96543_ - 23;
        if (NCRConfig.getClient().showServerSafety() && NCRConfig.getClient().enableMod()) {
            this.safetyStatusButton = new AdvancedImageButton(buttonX, this.f_96544_ - 37, 20, 20, SwitchableSprites.of(GUIShenanigans.getSprites("safety_state/insecure"), GUIShenanigans.getSprites("safety_state/unintrusive"), GUIShenanigans.getSprites("safety_state/secure"), GUIShenanigans.getSprites("safety_state/realms"), GUIShenanigans.getSprites("safety_state/unknown"), GUIShenanigans.getSprites("safety_state/undefined")).setIndex(this.getSpriteSet()), btn -> {
                if (!NCRClient.areSigningKeysPresent()) {
                    return;
                }
                ServerAddress address = ServerSafetyState.getLastServer();
                if (address != null) {
                    NCRServerPreferences preferences = NCRConfig.getServerPreferences();
                    preferences.setMode(address, preferences.getModeUnresolved(address).next());
                    preferences.saveFile();
                }
            }, (Component)Component.m_237119_(), this);
            this.safetyStatusButton.m_257544_(new AdvancedTooltip(() -> {
                MutableComponent tooltip = this.getSafetyLevel().getTooltip();
                if (ServerSafetyState.allowChatSigning()) {
                    tooltip = Component.m_237115_((String)"gui.nochatreports.safety_status.insecure_signing");
                } else if (ServerSafetyState.isInSingleplayer()) {
                    return tooltip;
                }
                ServerAddress address = ServerSafetyState.getLastServer();
                SigningMode mode = NCRConfig.getServerPreferences().getModeUnresolved(address);
                Object signing = "gui.nochatreports.signing_status.";
                signing = !this.f_96541_.m_91403_().m_104910_().m_129535_() ? (String)signing + "disabled_offline" : (ServerSafetyState.getCurrent() == ServerSafetyLevel.REALMS ? (String)signing + "allowed_realms" : (mode.resolve() == SigningMode.ALWAYS ? (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed" : (String)signing + "disabled_allowance_pending") : (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed_session" : (String)signing + "disabled")));
                tooltip.m_130946_("\n\n");
                tooltip.m_7220_((Component)Component.m_237115_((String)signing));
                if (ServerSafetyState.isOnRealms()) {
                    return tooltip;
                }
                tooltip.m_130946_("\n\n");
                tooltip.m_7220_((Component)Component.m_237115_((String)"gui.nochatreports.safety_status_button.controls"));
                tooltip.m_130946_("\n\n");
                tooltip.m_7220_((Component)Component.m_237110_((String)"gui.nochatreports.signing_mode", (Object[])new Object[]{mode.getName().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.AQUA})}));
                tooltip.m_130946_("\n");
                tooltip.m_7220_((Component)(mode == SigningMode.DEFAULT ? mode.resolve() : mode).getTooltip());
                return tooltip;
            }).setMaxWidth(250).setRenderWithoutGap(true));
            this.m_142416_((GuiEventListener)this.safetyStatusButton);
            buttonX -= 25;
        }
        if (!NCRConfig.getEncryption().showEncryptionButton()) {
            return;
        }
        int useSprites = !NCRConfig.getEncryption().isValid() ? 2 : (NCRConfig.getEncryption().isEnabled() ? 0 : 1);
        EncryptionButton button = new EncryptionButton(buttonX, this.f_96544_ - 37, 20, 20, useSprites, btn -> {
            if (!(EncryptionWarningScreen.seenOnThisSession() || NCRConfig.getEncryption().isWarningDisabled() || NCRConfig.getEncryption().isEnabled())) {
                Minecraft.m_91087_().m_91152_((Screen)new EncryptionWarningScreen(this));
            } else if (NCRConfig.getEncryption().isValid()) {
                NCRConfig.getEncryption().toggleEncryption();
                ((EncryptionButton)btn).useSprites(NCRConfig.getEncryption().isEnabledAndValid() ? 0 : 1);
            } else {
                ((EncryptionButton)btn).openEncryptionConfig();
            }
        }, (Component)Component.m_237119_(), (Screen)this);
        button.m_257544_(new AdvancedTooltip(() -> {
            if (NCRConfig.getEncryption().isValid()) {
                return Component.m_237110_((String)"gui.nochatreports.encryption_tooltip", (Object[])new Object[]{Language.m_128107_().m_6834_("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off")), TooltipHelper.getCtrl().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})});
            }
            return Component.m_237110_((String)"gui.nochatreports.encryption_tooltip_invalid", (Object[])new Object[]{Language.m_128107_().m_6834_("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off"))});
        }).setMaxWidth(250));
        button.f_93623_ = true;
        button.f_93624_ = true;
        this.m_142416_((GuiEventListener)button);
    }

    public void m_86600_() {
        if (this.safetyStatusButton != null) {
            this.safetyStatusButton.useSprites(this.getSpriteSet());
        }
    }

    private ServerSafetyLevel getSafetyLevel() {
        return ServerSafetyState.getCurrent();
    }

    private int getSpriteSet() {
        return this.getSpriteSet(this.getSafetyLevel());
    }

    private int getSpriteSet(ServerSafetyLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ServerSafetyLevel.INSECURE -> 0;
            case ServerSafetyLevel.UNINTRUSIVE -> 1;
            case ServerSafetyLevel.SECURE, ServerSafetyLevel.SINGLEPLAYER -> 2;
            case ServerSafetyLevel.REALMS -> 3;
            case ServerSafetyLevel.UNKNOWN -> 4;
            case ServerSafetyLevel.UNDEFINED -> 5;
        };
    }

    @Shadow
    public abstract String m_232706_(String var1);
}

