/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.EncryptionUtil;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public class MixinChatComponent {
    private static final GuiMessageTag.Icon ENCRYPTED_ICON = GuiMessageTag.Icon.valueOf((String)"CHAT_NCR_ENCRYPTED");
    private boolean lastMessageEncrypted;
    private Component lastMessageOriginal;

    @ModifyVariable(method={"addRecentChat"}, at=@At(value="HEAD"), argsOnly=true)
    private String onAddRecentChat(String message) {
        if (NCRConfig.getEncryption().isEnabledAndValid()) {
            return NCRConfig.getEncryption().getLastMessage();
        }
        return message;
    }

    @ModifyVariable(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ComponentRenderUtils;wrapComponents(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/client/gui/Font;)Ljava/util/List;", ordinal=0, shift=At.Shift.AFTER), argsOnly=true)
    private synchronized GuiMessageTag modifyGUITag(GuiMessageTag tag) {
        if (!NCRConfig.getEncryption().showEncryptionIndicators() || !this.lastMessageEncrypted) {
            return tag;
        }
        this.lastMessageEncrypted = false;
        MutableComponent tooltip = Component.m_237119_().m_7220_((Component)Component.m_237110_((String)"tag.nochatreports.encrypted", (Object[])new Object[]{Component.m_237113_((String)NCRConfig.getEncryption().getAlgorithm().getName()).m_130940_(ChatFormatting.BOLD)})).m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237110_((String)"tag.nochatreports.encrypted_original", (Object[])new Object[]{this.lastMessageOriginal}));
        return new GuiMessageTag(9125575, ENCRYPTED_ICON, (Component)tooltip, "Encrypted");
    }

    @ModifyArg(index=0, method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ComponentRenderUtils;wrapComponents(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/client/gui/Font;)Ljava/util/List;", ordinal=0))
    private FormattedText modifyGUIMessage(FormattedText msg) {
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Adding chat message, structure: " + Component.Serializer.m_130703_((Component)((Component)msg)));
        }
        Optional<Component> decrypted = EncryptionUtil.tryDecrypt((Component)msg);
        decrypted.ifPresentOrElse(component -> {
            this.lastMessageOriginal = EncryptionUtil.recreate((Component)msg);
            this.lastMessageEncrypted = true;
        }, () -> {
            this.lastMessageEncrypted = false;
        });
        return this.lastMessageEncrypted ? (FormattedText)decrypted.get() : msg;
    }
}

