/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.config.NCRConfigEncryption;
import com.aizistral.nochatreports.common.encryption.Encryption;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;

@Environment(value=EnvType.CLIENT)
public class EncryptionConfigScreen
extends Screen {
    private static final Component HEADER = Component.m_237115_((String)"gui.nochatreports.encryption_config.header");
    private static final Component KEY_DESC = Component.m_237115_((String)"gui.nochatreports.encryption_config.key_desc");
    private static final Component PASS_DESC = Component.m_237115_((String)"gui.nochatreports.encryption_config.passphrase_desc");
    private static final Component VALIDATION_OK = Component.m_237115_((String)"gui.nochatreports.encryption_config.validation_ok");
    private static final Component VALIDATION_FAILED = Component.m_237115_((String)"gui.nochatreports.encryption_config.validation_failed");
    private static final Component DICE_TOOLTIP = Component.m_237115_((String)"gui.nochatreports.encryption_config.dice_tooltip");
    private static final Component PASS_NOT_ALLOWED = Component.m_237115_((String)"gui.nochatreports.encryption_config.pass_not_allowed");
    private static final Component ENCRYPT_PUBLIC = Component.m_237115_((String)"gui.nochatreports.encryption_config.encrypt_public");
    private static final ResourceLocation CROSSMARK = new ResourceLocation("nochatreports", "encryption/crossmark_big");
    private static final int FIELDS_Y_START = 45;
    private final Screen previous;
    private CustomEditBox keyField;
    private CustomEditBox passField;
    private AdvancedImageButton validationIcon;
    private CycleButton<Encryption> algorithmButton;
    private MultiLineLabel keyDesc = MultiLineLabel.f_94331_;
    private MultiLineLabel passDesc = MultiLineLabel.f_94331_;
    protected Checkbox encryptPublicCheck;
    private boolean settingPassKey = false;

    public EncryptionConfigScreen(Screen previous) {
        super(CommonComponents.f_237098_);
        this.previous = previous;
    }

    private NCRConfigEncryption getConfig() {
        return NCRConfig.getEncryption();
    }

    protected void m_7856_() {
        CycleButton cycle;
        this.m_169413_();
        super.m_7856_();
        int w = (int)((double)this.f_96543_ * (this.hugeGUI() ? 0.9 : 0.7));
        this.keyDesc = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)KEY_DESC, (int)(w - 5));
        int keyDescSpace = (this.keyDesc.m_5770_() + 1) * this.getLineHeight();
        this.passDesc = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)PASS_DESC, (int)(w - 5));
        int passDescSpace = (this.passDesc.m_5770_() + 1) * this.getLineHeight();
        this.keyField = new CustomEditBox(this.f_96547_, (this.f_96543_ - (w -= 52)) / 2 - 2, (this.hugeGUI() ? 25 : 45) + keyDescSpace - 15, w, 18, CommonComponents.f_237098_);
        this.keyField.m_94199_(512);
        this.keyField.m_94151_(this::onKeyUpdate);
        this.m_7787_((GuiEventListener)this.keyField);
        AdvancedImageButton button = new AdvancedImageButton(this.keyField.m_252754_() + this.keyField.m_5711_() - 15, this.keyField.m_252907_() + 3, 12, 12, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/checkmark", false, false), GUIShenanigans.getSprites("encryption/crossmark", false, false)), btn -> {}, (Component)Component.m_237119_(), this);
        button.m_257544_(new AdvancedTooltip(() -> this.validationIcon != null && this.validationIcon.getSpritesIndex() == 0 ? VALIDATION_OK : VALIDATION_FAILED).setMaxWidth(250));
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.validationIcon = button;
        this.m_169394_((Renderable)this.validationIcon);
        button = new AdvancedImageButton(this.keyField.m_252754_() - 22, this.keyField.m_252907_() - 0, 18, 18, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/key_button", false, false), new WidgetSprites[0]), btn -> {}, (Component)Component.m_237119_(), this);
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.m_169394_((Renderable)button);
        button = new AdvancedImageButton(this.keyField.m_252754_() + this.keyField.m_5711_() + 4, this.keyField.m_252907_() - 1, 23, 20, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/random_button"), new WidgetSprites[0]), btn -> {
            this.unfocusFields();
            this.keyField.m_94144_(((Encryption)this.algorithmButton.m_168883_()).getRandomKey());
        }, (Component)Component.m_237119_(), this);
        button.m_257544_(new AdvancedTooltip(DICE_TOOLTIP).setMaxWidth(250));
        button.f_93623_ = true;
        button.f_93624_ = true;
        this.m_142416_((GuiEventListener)button);
        this.passField = new CustomEditBox(this.f_96547_, (this.f_96543_ - (w += 25)) / 2 + 11, this.keyField.m_252907_() + this.keyField.m_93694_() + passDescSpace + (this.hugeGUI() ? -3 : 13), w, 18, CommonComponents.f_237098_);
        this.passField.m_94199_(512);
        this.passField.m_94151_(this::onPassphraseUpdate);
        this.m_7787_((GuiEventListener)this.passField);
        button = new AdvancedImageButton(this.passField.m_252754_() - 22, this.passField.m_252907_() - 0, 18, 18, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/lock_button", false, false), new WidgetSprites[0]), btn -> {}, (Component)Component.m_237119_(), this);
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.m_169394_((Renderable)button);
        int checkWidth = this.f_96547_.m_92852_((FormattedText)ENCRYPT_PUBLIC);
        this.encryptPublicCheck = Checkbox.m_306644_((Component)ENCRYPT_PUBLIC, (Font)this.f_96547_).m_307310_(this.f_96543_ / 2 - checkWidth / 2 - 8, this.passField.m_252907_() + 24).m_307950_(NCRConfig.getEncryption().shouldEncryptPublic()).m_307240_();
        this.m_142416_((GuiEventListener)this.encryptPublicCheck);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, btn -> {
            this.onDone();
            this.m_7379_();
        }).m_252794_(this.f_96543_ / 2 + 4, this.passField.m_252907_() + 48).m_253046_(219, 20).m_253136_());
        this.algorithmButton = cycle = CycleButton.m_168894_(value -> Component.m_237110_((String)"gui.nochatreports.encryption_config.algorithm", (Object[])new Object[]{Component.m_237115_((String)("algorithm.nochatreports." + value.getID() + ".name"))})).m_232502_(Encryption.getRegistered()).m_168929_().m_168948_((Object)this.getConfig().getAlgorithm()).m_232498_(value -> new AdvancedTooltip((Component)Component.m_237115_((String)("algorithm.nochatreports." + value.getID()))).setMaxWidth(250)).m_168936_(this.f_96543_ / 2 - 4 - 218, this.passField.m_252907_() + 48, 218, 20, CommonComponents.f_237098_, (cycleButton, value) -> {
            this.unfocusFields();
            this.onAlgorithmUpdate((Encryption)value);
        });
        this.m_142416_((GuiEventListener)this.algorithmButton);
        this.onAlgorithmUpdate((Encryption)this.algorithmButton.m_168883_());
        if (!StringUtil.m_14408_((String)this.getConfig().getEncryptionPassphrase())) {
            this.passField.m_94144_(this.getConfig().getEncryptionPassphrase());
        } else if (!StringUtil.m_14408_((String)this.getConfig().getEncryptionKey())) {
            if (!Objects.equals(this.getConfig().getEncryptionKey(), ((Encryption)this.algorithmButton.m_168883_()).getDefaultKey())) {
                this.keyField.m_94144_(this.getConfig().getEncryptionKey());
            } else {
                this.keyField.m_94144_("");
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        if (!this.passField.m_142518_()) {
            if (this.passField.m_93696_()) {
                this.passField.m_93692_(false);
            }
            this.passField.m_94186_(false);
        }
        this.m_280273_(graphics, j, j, f);
        graphics.m_280653_(this.f_96547_, HEADER, this.f_96543_ / 2, this.hugeGUI() ? 8 : 16, 0xFFFFFF);
        this.keyDesc.m_6508_(graphics, this.keyField.m_252754_() - 20, this.hugeGUI() ? 25 : 45, this.getLineHeight(), 0xFFFFFF);
        this.keyField.m_88315_(graphics, i, j, f);
        this.passDesc.m_6508_(graphics, this.passField.m_252754_() - 20, this.keyField.m_252907_() + this.keyField.m_93694_() + (this.hugeGUI() ? 12 : 28), this.getLineHeight(), 0xFFFFFF);
        this.passField.m_88315_(graphics, i, j, f);
        super.m_88315_(graphics, i, j, f);
        if (StringUtil.m_14408_((String)this.keyField.m_94155_()) && !this.keyField.m_93696_()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.nochatreports.encryption_config.default_key", (Object[])new Object[]{((Encryption)this.algorithmButton.m_168883_()).getDefaultKey()}), this.keyField.m_252754_() + 4, this.keyField.m_252907_() + 5, 0x999999);
        }
        if (!this.passField.f_93623_) {
            graphics.m_280430_(this.f_96547_, PASS_NOT_ALLOWED, this.passField.m_252754_() + 4, this.passField.m_252907_() + 5, 0x999999);
            RenderSystem.enableDepthTest();
            graphics.m_292816_(CROSSMARK, this.passField.m_252754_() - 20, this.passField.m_252907_() + 3, 14, 13);
        }
    }

    private int getLineHeight() {
        if (this.hugeGUI()) {
            Objects.requireNonNull(this.f_96541_.f_91062_);
            return (int)(9.0 * 1.5) + 1;
        }
        Objects.requireNonNull(this.f_96541_.f_91062_);
        return 9 * 2;
    }

    private void onKeyUpdate(String key) {
        if (!this.settingPassKey) {
            this.passField.m_94144_("");
        }
        if (!StringUtil.m_14408_((String)key)) {
            this.validationIcon.useSprites(((Encryption)this.algorithmButton.m_168883_()).validateKey(key) ? 0 : 1);
        } else {
            this.validationIcon.useSprites(0);
        }
    }

    private void onPassphraseUpdate(String pass) {
        Encryption encryption = (Encryption)this.algorithmButton.m_168883_();
        this.settingPassKey = true;
        if (!StringUtil.m_14408_((String)pass)) {
            if (encryption.supportsPassphrases()) {
                this.keyField.m_94144_(encryption.getPassphraseKey(pass));
            }
        } else {
            this.onKeyUpdate(this.keyField.m_94155_());
        }
        this.settingPassKey = false;
    }

    private void onAlgorithmUpdate(Encryption encryption) {
        if (!encryption.supportsPassphrases()) {
            this.passField.m_93692_(false);
            this.passField.f_93623_ = false;
            this.passField.m_94186_(false);
            this.onKeyUpdate(this.keyField.m_94155_());
        } else {
            this.passField.f_93623_ = true;
            this.passField.m_94186_(true);
            this.onPassphraseUpdate(this.passField.m_94155_());
        }
    }

    private void unfocusFields() {
        this.keyField.m_93692_(false);
        this.passField.m_93692_(false);
    }

    private void onDone() {
        NCRConfigEncryption config = NCRConfig.getEncryption();
        Encryption encryption = (Encryption)this.algorithmButton.m_168883_();
        config.setAlgorithm(encryption);
        config.setEncryptionKey(!StringUtil.m_14408_((String)this.keyField.m_94155_()) ? this.keyField.m_94155_() : encryption.getDefaultKey());
        config.setEncryptPublic(this.encryptPublicCheck.m_93840_());
    }

    private boolean hugeGUI() {
        return this.f_96544_ <= 270;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previous);
    }

    private static class CustomEditBox
    extends EditBox {
        public CustomEditBox(Font font, int i, int j, int k, int l, Component component) {
            super(font, i, j, k, l, component);
        }

        public void m_93692_(boolean bl) {
            super.m_93692_(bl);
        }
    }
}

