/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.goldenfoods.item;

import forge.net.jason13.goldenfoods.item.block.EnchantedBlockItem;
import forge.net.jason13.goldenfoods.item.block.EnchantedGoldenCakeBlock;
import forge.net.jason13.goldenfoods.item.block.GoldenCakeBlock;
import forge.net.jason13.goldenfoods.item.custom.EnchantedBowlFoodItem;
import forge.net.jason13.goldenfoods.item.custom.EnchantedGoldenChorusFruitItem;
import forge.net.jason13.goldenfoods.item.custom.EnchantedHoneyBottleItem;
import forge.net.jason13.goldenfoods.item.custom.EnchantedMilkBucketItem;
import forge.net.jason13.goldenfoods.item.custom.GoldenChorusFruitItem;
import forge.net.jason13.goldenfoods.item.custom.GoldenMilkBucketItem;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.EnchantedGoldenAppleItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"goldenfoods");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"goldenfoods");
    public static final Item.Properties GOLDEN_FOOD_PROPERTIES = new Item.Properties().m_41497_(Rarity.RARE).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(1.2f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 100, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19617_, 2400, 0), 1.0f).m_38765_().m_38767_());
    public static final Item.Properties ENCHANTED_GOLDEN_FOOD_PROPERTIES = new Item.Properties().m_41497_(Rarity.EPIC).m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(8.0f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 400, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19606_, 6000, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19607_, 6000, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19617_, 2400, 3), 1.0f).m_38765_().m_38767_());
    public static final RegistryObject<Item> GOLDEN_MELON_SLICE = ForgeItems.registerGoldenFoodItem("golden_melon_slice");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_MELON_SLICE = ForgeItems.registerGoldenFoodItem("enchanted_golden_melon_slice");
    public static final RegistryObject<Item> GOLDEN_SWEET_BERRIES = ForgeItems.registerGoldenFoodItem("golden_sweet_berries");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_SWEET_BERRIES = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_sweet_berries");
    public static final RegistryObject<Item> GOLDEN_GLOW_BERRIES = ForgeItems.registerGoldenFoodItem("golden_glow_berries");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_GLOW_BERRIES = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_glow_berries");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_CARROT = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_carrot");
    public static final RegistryObject<Item> GOLDEN_BAKED_POTATO = ForgeItems.registerGoldenFoodItem("golden_baked_potato");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_BAKED_POTATO = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_baked_potato");
    public static final RegistryObject<Item> GOLDEN_BEETROOT = ForgeItems.registerGoldenFoodItem("golden_beetroot");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_BEETROOT = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_beetroot");
    public static final RegistryObject<Item> GOLDEN_DRIED_KELP = ForgeItems.registerGoldenFoodItem("golden_dried_kelp");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_DRIED_KELP = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_dried_kelp");
    public static final RegistryObject<Item> GOLDEN_COOKED_BEEF = ForgeItems.registerGoldenFoodItem("golden_cooked_beef");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_BEEF = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_beef");
    public static final RegistryObject<Item> GOLDEN_COOKED_PORKCHOP = ForgeItems.registerGoldenFoodItem("golden_cooked_porkchop");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_PORKCHOP = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_porkchop");
    public static final RegistryObject<Item> GOLDEN_COOKED_MUTTON = ForgeItems.registerGoldenFoodItem("golden_cooked_mutton");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_MUTTON = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_mutton");
    public static final RegistryObject<Item> GOLDEN_COOKED_CHICKEN = ForgeItems.registerGoldenFoodItem("golden_cooked_chicken");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_CHICKEN = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_chicken");
    public static final RegistryObject<Item> GOLDEN_COOKED_RABBIT = ForgeItems.registerGoldenFoodItem("golden_cooked_rabbit");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_RABBIT = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_rabbit");
    public static final RegistryObject<Item> GOLDEN_COOKED_COD = ForgeItems.registerGoldenFoodItem("golden_cooked_cod");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_COD = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_cod");
    public static final RegistryObject<Item> GOLDEN_COOKED_SALMON = ForgeItems.registerGoldenFoodItem("golden_cooked_salmon");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKED_SALMON = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cooked_salmon");
    public static final RegistryObject<Item> GOLDEN_BREAD = ForgeItems.registerGoldenFoodItem("golden_bread");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_BREAD = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_bread");
    public static final RegistryObject<Item> GOLDEN_COOKIE = ForgeItems.registerGoldenFoodItem("golden_cookie");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_COOKIE = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_cookie");
    public static final RegistryObject<Item> GOLDEN_PUMPKIN_PIE = ForgeItems.registerGoldenFoodItem("golden_pumpkin_pie");
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_PUMPKIN_PIE = ForgeItems.registerEnchantedGoldenFoodItem("enchanted_golden_pumpkin_pie");
    public static final RegistryObject<Block> GOLDEN_CAKE = ForgeItems.registerBlockAndBlockItem("golden_cake", () -> new GoldenCakeBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> ENCHANTED_GOLDEN_CAKE = ForgeItems.registerEnchantedBlockAndBlockItem("enchanted_golden_cake", () -> new EnchantedGoldenCakeBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Item> GOLDEN_CHORUS_FRUIT = ForgeItems.registerItem("golden_chorus_fruit", () -> new GoldenChorusFruitItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_CHORUS_FRUIT = ForgeItems.registerItem("enchanted_golden_chorus_fruit", () -> new EnchantedGoldenChorusFruitItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> GOLDEN_MUSHROOM_STEW = ForgeItems.registerItem("golden_mushroom_stew", () -> new BowlFoodItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_MUSHROOM_STEW = ForgeItems.registerItem("enchanted_golden_mushroom_stew", () -> new EnchantedBowlFoodItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> GOLDEN_BEETROOT_SOUP = ForgeItems.registerItem("golden_beetroot_soup", () -> new BowlFoodItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_BEETROOT_SOUP = ForgeItems.registerItem("enchanted_golden_beetroot_soup", () -> new EnchantedBowlFoodItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> GOLDEN_RABBIT_STEW = ForgeItems.registerItem("golden_rabbit_stew", () -> new BowlFoodItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_RABBIT_STEW = ForgeItems.registerItem("enchanted_golden_rabbit_stew", () -> new EnchantedBowlFoodItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> GOLDEN_MILK_BUCKET = ForgeItems.registerItem("golden_milk_bucket", () -> new GoldenMilkBucketItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_MILK_BUCKET = ForgeItems.registerItem("enchanted_golden_milk_bucket", () -> new EnchantedMilkBucketItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> GOLDEN_HONEY_BOTTLE = ForgeItems.registerItem("golden_honey_bottle", () -> new HoneyBottleItem(GOLDEN_FOOD_PROPERTIES));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_HONEY_BOTTLE = ForgeItems.registerItem("enchanted_golden_honey_bottle", () -> new EnchantedHoneyBottleItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
    }

    public static <T extends Item> RegistryObject<Item> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item::get);
    }

    public static <T extends Item> RegistryObject<Item> registerGoldenFoodItem(String name) {
        return ITEMS.register(name, () -> new Item(GOLDEN_FOOD_PROPERTIES));
    }

    public static <T extends Item> RegistryObject<Item> registerEnchantedGoldenFoodItem(String name) {
        return ITEMS.register(name, () -> new EnchantedGoldenAppleItem(ENCHANTED_GOLDEN_FOOD_PROPERTIES));
    }

    private static <T extends Block> RegistryObject<T> registerBlockAndBlockItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ForgeItems.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, Supplier<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(Rarity.RARE)));
    }

    private static <T extends Block> RegistryObject<T> registerEnchantedBlockAndBlockItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ForgeItems.registerEnchantedBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerEnchantedBlockItem(String name, Supplier<T> block) {
        return ITEMS.register(name, () -> new EnchantedBlockItem((Block)block.get(), new Item.Properties().m_41497_(Rarity.EPIC)));
    }
}

