/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.config.ScreenWithOptionList;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.CustomOptionList;
import dlovin.inventoryhud.gui.widgets.IconWidget;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;

public class EffectsBlackListScreen
extends ScreenWithOptionList {
    private final boolean inGame;
    private CustomButton saveBtn;

    public EffectsBlackListScreen(boolean inGame) {
        super(Translation.BLACKLIST_TITLE);
        this.inGame = inGame;
    }

    protected void m_7856_() {
        this.optionList = new CustomOptionList(this.f_96541_, this, 32);
        this.addControlLine();
        List effectList = (List)InventoryHUD.getClientConfig().effectsBlacklist.get();
        for (int i = 0; i < effectList.size(); ++i) {
            this.addLine(i, (String)effectList.get(i));
        }
        this.m_142416_((GuiEventListener)this.optionList);
    }

    private void addLine(int i, String effect) {
        IconWidget effectIcon = new IconWidget(this.f_96543_ / 2 + 105, 0, 20, 20, effect);
        this.optionList.insertWidget(effectIcon, i);
        this.optionList.addWidget(new TextField(this.f_96547_, this.f_96543_ / 2 - 100, 0, 200, 20, effect, w -> {
            effectIcon.setEffectAtlasSprite(w.getText());
            this.saveBtn.setMessage(ChatFormatting.RED + Translation.SAVE.getString());
        }, "[a-z0-9._-]*[/:]?[a-z0-9._-]*"), i);
        int deleteBtnSize = this.f_96547_.m_92895_(Translation.DELETE.getString()) + 8;
        CustomButton deleteBtn = new CustomButton(this.f_96543_ / 2 - deleteBtnSize - 105, 0, deleteBtnSize, 20, Translation.DELETE.getString(), null, false);
        this.optionList.addWidget(deleteBtn, i);
        deleteBtn.addListener(btn -> {
            this.optionList.removeRowWith(deleteBtn);
            this.saveBtn.setMessage(ChatFormatting.RED + Translation.SAVE.getString());
        });
    }

    private void addControlLine() {
        int saveBtnSize = this.f_96547_.m_92895_(Translation.SAVE.getString()) + 8;
        int addBtnSize = this.f_96547_.m_92895_(Translation.ADD.getString()) + 8;
        this.saveBtn = new CustomButton(this.f_96543_ / 2 - saveBtnSize - 5, 0, saveBtnSize, 20, ChatFormatting.GREEN + Translation.SAVE.getString(), null, false);
        this.optionList.addWidget(this.saveBtn, 0);
        this.saveBtn.addListener(this::saveEffects);
        CustomButton nextButton = new CustomButton(this.f_96543_ / 2 + 5, 0, addBtnSize, 20, Translation.ADD.getString(), null, false);
        this.optionList.addWidget(nextButton, 0);
        nextButton.addListener(this::addEffect);
    }

    private void saveEffects(ButtonWidget btn) {
        List<String> effects = this.optionList.getWidgets().stream().filter(w -> w instanceof TextField).map(w -> ((TextField)w).getText()).toList();
        InventoryHUD.getClientConfig().effectsBlacklist.set(effects);
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().resetBlackList();
        this.saveBtn.setMessage(ChatFormatting.GREEN + Translation.SAVE.getString());
    }

    private void addEffect(ButtonWidget btn) {
        this.addLine(this.optionList.rowsCount() - 1, "");
        this.saveBtn.setMessage(ChatFormatting.RED + Translation.SAVE.getString());
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gui, mouseX, mouseY, partialTick);
        this.optionList.m_88315_(gui, mouseX, mouseY, partialTick);
        this.renderTitle(gui);
        this.optionList.renderTooltips(gui, mouseX, mouseY);
    }

    public void renderTitle(@NotNull GuiGraphics gui) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_((double)this.f_96543_ * 0.5, 10.0, 0.0);
        gui.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        gui.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        gui.m_280137_(this.f_96547_, this.f_96539_.getString(), 0, 0, -1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        gui.m_280168_().m_85849_();
        gui.m_280168_().m_85849_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new PotionConfigScreen(this.inGame));
    }
}

