/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.morebowsandarrows;

import forge.net.jason13.morebowsandarrows.CommonClass;
import forge.net.jason13.morebowsandarrows.CommonConstants;
import forge.net.jason13.morebowsandarrows.registry.ForgeBowRepairRegistry;
import forge.net.jason13.morebowsandarrows.registry.ForgeCreativeModeTabRegistry;
import forge.net.jason13.morebowsandarrows.registry.ForgeDispenserBehaviorRegistry;
import forge.net.jason13.morebowsandarrows.registry.ForgeEntityTypeRegistry;
import forge.net.jason13.morebowsandarrows.registry.ForgeItemProperties;
import forge.net.jason13.morebowsandarrows.registry.ForgeItemRegistry;
import net.jason13.monolib.methods.BlockMethods;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="morebowsandarrows")
public class ForgeExampleMod {
    public static boolean debuggingEnabled = false;

    public ForgeExampleMod() {
        CommonConstants.LOG.info("Hello Forge world!");
        CommonClass.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::clientSetup);
        bus.addListener(this::commonSetup);
        ForgeItemRegistry.register(bus);
        ForgeEntityTypeRegistry.register(bus);
        ForgeCreativeModeTabRegistry.register(bus);
        bus.addListener(ForgeCreativeModeTabRegistry::addToCombatTab);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ForgeItemProperties::addCustomItemProperties);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ForgeDispenserBehaviorRegistry.registerArrowsAsProjectiles();
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ForgeBowRepairRegistry.register(event);
    }

    @SubscribeEvent
    public void onStartTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                boolean leftHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21206_());
                boolean rightHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21205_());
                if (debuggingEnabled || !leftHandCommand || !rightHandCommand) continue;
                player.m_213846_((Component)Component.m_237113_((String)"Ticking!"));
                debuggingEnabled = true;
            }
        }
    }
}

