/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.client.renderer;

import com.girafi.waddles.client.ClientHelper;
import com.girafi.waddles.client.model.PenguinModel;
import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.girafi.waddles.utils.ConfigurationHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class PenguinRenderer
extends MobRenderer<AdeliePenguinEntity, PenguinModel<AdeliePenguinEntity>> {
    public PenguinRenderer(EntityRendererProvider.Context context) {
        super(context, new PenguinModel(context.m_174023_(ClientHelper.PENGUIN_LAYER)), 0.5f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AdeliePenguinEntity penguin) {
        String name;
        return switch (name = penguin.m_7755_().getString().toLowerCase().trim()) {
            case "joshie", "joshiejack" -> this.getPenguinTexture("joshie");
            case "darkosto" -> this.getPenguinTexture("darkosto");
            case "waddles", "adelie", "girafi", "wiiv" -> this.getDefault(penguin);
            default -> (Boolean)ConfigurationHandler.GENERAL.darkostoDefault.get() != false ? this.getPenguinTexture("darkosto") : this.getDefault(penguin);
        };
    }

    private ResourceLocation getDefault(@Nonnull AdeliePenguinEntity penguin) {
        return penguin.m_6162_() ? this.getPenguinTexture("adelie_child") : this.getPenguinTexture("adelie");
    }

    private ResourceLocation getPenguinTexture(String fileName) {
        return new ResourceLocation("waddles", "textures/entity/penguin/" + fileName + ".png");
    }
}

