/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.client.model;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PenguinModel<T extends AdeliePenguinEntity>
extends AgeableListModel<T> {
    private ModelPart head;
    private ModelPart beak;
    private ModelPart body;
    private ModelPart flipperLeft;
    private ModelPart flipperRight;
    private ModelPart feetLeft;
    private ModelPart feetRight;
    private ModelPart tail;

    public PenguinModel(ModelPart part) {
        super(false, 6.0f, 0.0f);
        this.head = part.m_171324_("head");
        this.beak = part.m_171324_("beak");
        this.body = part.m_171324_("body");
        this.flipperLeft = part.m_171324_("flipper_left");
        this.flipperRight = part.m_171324_("flipper_right");
        this.feetLeft = part.m_171324_("feet_left");
        this.feetRight = part.m_171324_("feet_right");
        this.tail = part.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.m_171576_();
        def.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        def.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171481_(-0.5f, -3.0f, -4.0f, 1.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        def.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-2.5f, 0.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)1.0f));
        def.m_171599_("flipper_left", CubeListBuilder.m_171558_().m_171514_(20, 10).m_171480_().m_171481_(0.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f), PartPose.m_171423_((float)2.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.08726646f));
        def.m_171599_("flipper_right", CubeListBuilder.m_171558_().m_171514_(20, 10).m_171481_(-1.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f), PartPose.m_171423_((float)-2.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.08726646f));
        def.m_171599_("feet_left", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171480_().m_171481_(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        def.m_171599_("feet_right", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        def.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171481_(-1.5f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)3.0f, (float)1.2566371f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelDefinition, (int)32, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.beak);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.flipperLeft, (Object)this.flipperRight, (Object)this.feetLeft, (Object)this.feetRight, (Object)this.tail);
    }

    public void setupAnim(@Nonnull AdeliePenguinEntity penguin, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.beak.f_104203_ = this.head.f_104203_;
        this.beak.f_104204_ = this.head.f_104204_;
        this.body.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.feetRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.3324f)) * 1.2f * limbSwingAmount;
        this.feetLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.3324f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.flipperRight.f_104205_ = 0.08726646f + Mth.m_14089_((float)penguin.rotationFlipper) * limbSwingAmount;
        this.flipperLeft.f_104205_ = -0.08726646f + Mth.m_14089_((float)((float)penguin.rotationFlipper + (float)Math.PI)) * limbSwingAmount;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * 1.4f * limbSwingAmount;
    }
}

