/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles;

import com.girafi.waddles.CommonClass;
import com.girafi.waddles.PenguinSpawn;
import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.util.function.Supplier;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="waddles")
public class Waddles {
    public static final DeferredRegister<Item> ITEM_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waddles");

    public Waddles() {
        CommonClass.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setupCommon);
        eventBus.addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigurationHandler.spec);
        Waddles.registerDeferredRegistries(eventBus);
        this.register();
    }

    public void setupCommon(FMLCommonSetupEvent event) {
    }

    public void setupClient(FMLClientSetupEvent event) {
    }

    public void register() {
        PenguinRegistry.PENGUINS.forEach((penguin, name) -> {
            RegistryObject spawnEgg = ITEM_DEFERRED.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)penguin, PenguinRegistry.PENGUIN_EGG_PRIMARY.get(penguin).intValue(), PenguinRegistry.PENGUIN_EGG_SECONDARY.get(penguin).intValue(), new Item.Properties()));
            PenguinRegistry.SPAWN_EGGS.add((Supplier<Item>)spawnEgg);
        });
        PenguinSpawn.BIOME_MODIFIER_SERIALIZERS_DEFERRED.register("penguin_spawn", PenguinSpawn.PenguinBiomeModifier::makeCodec);
    }

    public static void registerDeferredRegistries(IEventBus modBus) {
        PenguinSpawn.BIOME_MODIFIER_SERIALIZERS_DEFERRED.register(modBus);
        ITEM_DEFERRED.register(modBus);
    }

    @Mod.EventBusSubscriber(modid="waddles", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Events {
        @SubscribeEvent
        public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register(PenguinRegistry.ADELIE_PENGUIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdeliePenguinEntity::canPenguinSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        }

        @SubscribeEvent
        public static void addEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(PenguinRegistry.ADELIE_PENGUIN.get(), AdeliePenguinEntity.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void addToCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256731_) {
                PenguinRegistry.SPAWN_EGGS.forEach(stack -> event.m_246326_((ItemLike)stack.get()));
            }
        }
    }
}

