/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.biome.BOPEndBiomes;
import biomesoplenty.biome.BOPNetherBiomes;
import biomesoplenty.biome.BOPOverworldBiomes;
import biomesoplenty.init.ModConfig;
import biomesoplenty.worldgen.BOPNetherRegionCommon;
import biomesoplenty.worldgen.BOPNetherRegionRare;
import biomesoplenty.worldgen.BOPOverworldRegionPrimary;
import biomesoplenty.worldgen.BOPOverworldRegionRare;
import biomesoplenty.worldgen.BOPOverworldRegionSecondary;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import terrablender.api.EndBiomeRegistry;
import terrablender.api.Region;
import terrablender.api.Regions;

public class ModBiomes {
    public static void setup() {
        ModBiomes.registerVillagerTypes();
    }

    public static void setupTerraBlender() {
        Regions.register((Region)new BOPOverworldRegionPrimary(ModConfig.generation.bopPrimaryOverworldRegionWeight));
        Regions.register((Region)new BOPOverworldRegionSecondary(ModConfig.generation.bopSecondaryOverworldRegionWeight));
        Regions.register((Region)new BOPOverworldRegionRare(ModConfig.generation.bopOverworldRareRegionWeight));
        Regions.register((Region)new BOPNetherRegionCommon(ModConfig.generation.bopNetherRegionWeight));
        Regions.register((Region)new BOPNetherRegionRare(ModConfig.generation.bopNetherRareRegionWeight));
        EndBiomeRegistry.registerHighlandsBiome(BOPBiomes.END_WILDS, (int)9);
        EndBiomeRegistry.registerHighlandsBiome(BOPBiomes.END_REEF, (int)6);
        EndBiomeRegistry.registerHighlandsBiome(BOPBiomes.END_CORRUPTION, (int)3);
    }

    public static void bootstrapBiomes(BootstapContext<Biome> context) {
        HolderGetter carverGetter = context.m_255420_(Registries.f_257003_);
        HolderGetter placedFeatureGetter = context.m_255420_(Registries.f_256988_);
        ModBiomes.register(context, BOPBiomes.ASPEN_GLADE, BOPOverworldBiomes.aspenGlade((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.AURORAL_GARDEN, BOPOverworldBiomes.auroralGarden((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.BAYOU, BOPOverworldBiomes.bayou((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.BOG, BOPOverworldBiomes.bog((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.COLD_DESERT, BOPOverworldBiomes.coldDesert((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.CONIFEROUS_FOREST, BOPOverworldBiomes.coniferousForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.CRAG, BOPOverworldBiomes.crag((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.DEAD_FOREST, BOPOverworldBiomes.deadForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.DRYLAND, BOPOverworldBiomes.dryland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.DUNE_BEACH, BOPOverworldBiomes.duneBeach((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.FIELD, BOPOverworldBiomes.field((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.FIR_CLEARING, BOPOverworldBiomes.firClearing((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.FLOODPLAIN, BOPOverworldBiomes.floodplain((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.FORESTED_FIELD, BOPOverworldBiomes.field((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.FUNGAL_JUNGLE, BOPOverworldBiomes.fungalJungle((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.GRASSLAND, BOPOverworldBiomes.grassland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.GRAVEL_BEACH, BOPOverworldBiomes.gravelBeach((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.HIGHLAND, BOPOverworldBiomes.highland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.HOT_SPRINGS, BOPOverworldBiomes.hotSprings((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.JACARANDA_GLADE, BOPOverworldBiomes.jacarandaGlade((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.JADE_CLIFFS, BOPOverworldBiomes.jadeCliffs((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.LAVENDER_FIELD, BOPOverworldBiomes.lavenderField((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.LUSH_DESERT, BOPOverworldBiomes.lushDesert((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.LUSH_SAVANNA, BOPOverworldBiomes.lushSavanna((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.MAPLE_WOODS, BOPOverworldBiomes.mapleWoods((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.MARSH, BOPOverworldBiomes.marsh((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.MEDITERRANEAN_FOREST, BOPOverworldBiomes.mediterraneanForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.MOOR, BOPOverworldBiomes.moor((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.MUSKEG, BOPOverworldBiomes.muskeg((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.MYSTIC_GROVE, BOPOverworldBiomes.mysticGrove((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.OLD_GROWTH_DEAD_FOREST, BOPOverworldBiomes.oldGrowthDeadForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.OLD_GROWTH_WOODLAND, BOPOverworldBiomes.woodland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.OMINOUS_WOODS, BOPOverworldBiomes.ominousWoods((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.ORCHARD, BOPOverworldBiomes.orchard((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.ORIGIN_VALLEY, BOPOverworldBiomes.originValley((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.OVERGROWN_GREENS, BOPOverworldBiomes.overgrownGreens((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.PASTURE, BOPOverworldBiomes.pasture((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.PRAIRIE, BOPOverworldBiomes.prairie((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.PUMPKIN_PATCH, BOPOverworldBiomes.pumpkinPatch((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.RAINFOREST, BOPOverworldBiomes.rainforest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.REDWOOD_FOREST, BOPOverworldBiomes.redwoodForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.ROCKY_RAINFOREST, BOPOverworldBiomes.rockyRainforest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.ROCKY_SHRUBLAND, BOPOverworldBiomes.rockyShrubland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SCRUBLAND, BOPOverworldBiomes.scrubland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SEASONAL_FOREST, BOPOverworldBiomes.seasonalForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SHRUBLAND, BOPOverworldBiomes.shrubland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SNOWBLOSSOM_GROVE, BOPOverworldBiomes.snowblossomGrove((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPOverworldBiomes.coniferousForest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.SNOWY_FIR_CLEARING, BOPOverworldBiomes.firClearing((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.SNOWY_MAPLE_WOODS, BOPOverworldBiomes.mapleWoods((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.TROPICS, BOPOverworldBiomes.tropics((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.TUNDRA, BOPOverworldBiomes.tundra((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.VOLCANIC_PLAINS, BOPOverworldBiomes.volcanicPlains((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.VOLCANO, BOPOverworldBiomes.volcano((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.WASTELAND, BOPOverworldBiomes.wasteland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.WASTELAND_STEPPE, BOPOverworldBiomes.wastelandSteppe((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.WETLAND, BOPOverworldBiomes.wetland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPOverworldBiomes.originValley((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, true));
        ModBiomes.register(context, BOPBiomes.WOODLAND, BOPOverworldBiomes.woodland((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter, false));
        ModBiomes.register(context, BOPBiomes.GLOWING_GROTTO, BOPOverworldBiomes.glowingGrotto((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.SPIDER_NEST, BOPOverworldBiomes.spiderNest((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.CRYSTALLINE_CHASM, BOPNetherBiomes.crystallineChasm((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.ERUPTING_INFERNO, BOPNetherBiomes.eruptingInferno((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.UNDERGROWTH, BOPNetherBiomes.undergrowth((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.VISCERAL_HEAP, BOPNetherBiomes.visceralHeap((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.WITHERED_ABYSS, BOPNetherBiomes.witheredAbyss((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.END_WILDS, BOPEndBiomes.endWilds((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.END_REEF, BOPEndBiomes.endReef((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
        ModBiomes.register(context, BOPBiomes.END_CORRUPTION, BOPEndBiomes.endCorruption((HolderGetter<PlacedFeature>)placedFeatureGetter, carverGetter));
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.ASPEN_GLADE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.AURORAL_GARDEN, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.BAYOU, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.BOG, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.COLD_DESERT, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.CONIFEROUS_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.CRAG, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.DRYLAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.DUNE_BEACH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.FIR_CLEARING, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FLOODPLAIN, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.FORESTED_FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FUNGAL_JUNGLE, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.GRASSLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.GRAVEL_BEACH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HIGHLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HOT_SPRINGS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.JACARANDA_GLADE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.JADE_CLIFFS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LAVENDER_FIELD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_DESERT, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_SAVANNA, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.MARSH, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.MEDITERRANEAN_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.MOOR, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.MUSKEG, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.MYSTIC_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_WOODLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OMINOUS_WOODS, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.ORCHARD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ORIGIN_VALLEY, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OVERGROWN_GREENS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PASTURE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PRAIRIE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PUMPKIN_PATCH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.REDWOOD_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SCRUBLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.SEASONAL_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWBLOSSOM_GROVE, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_CONIFEROUS_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_FIR_CLEARING, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.TROPICS, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.TUNDRA, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANIC_PLAINS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANO, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.WASTELAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WASTELAND_STEPPE, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WETLAND, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.WINTRY_ORIGIN_VALLEY, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODLAND, VillagerType.f_35821_);
    }

    private static void register(BootstapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.m_255272_(key, (Object)biome);
    }

    private static void registerVillagerType(ResourceKey<Biome> key, VillagerType type) {
        if (ModConfig.isBiomeEnabled(key)) {
            VillagerType.f_35827_.put(key, type);
        }
    }
}

