/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.renderer;

import biomesoplenty.entity.BoatBOP;
import biomesoplenty.entity.ChestBoatBOP;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class BoatRendererBOP
extends EntityRenderer<Boat> {
    private final Map<BoatBOP.ModelType, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public BoatRendererBOP(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(BoatBOP.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)new ResourceLocation("biomesoplenty", BoatRendererBOP.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (BoatBOP.ModelType)((Object)model), hasChest))));
    }

    public void render(Boat boat, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float f2;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        float f = (float)boat.m_305464_() - partialTicks;
        float f1 = boat.m_304923_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_305195_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(listmodel.m_103119_(resourcelocation));
        listmodel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)boat, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(Boat boat) {
        return (ResourceLocation)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof ChestBoatBOP) {
            return this.boatResources.get((Object)((ChestBoatBOP)boat).getModel());
        }
        return this.boatResources.get((Object)((BoatBOP)boat).getModel());
    }

    private static String getTextureLocation(BoatBOP.ModelType model, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + model.getName() + ".png" : "textures/entity/boat/" + model.getName() + ".png";
    }

    private static ModelLayerLocation createLocation(String name, String layer) {
        return new ModelLayerLocation(new ResourceLocation("biomesoplenty", name), layer);
    }

    public static ModelLayerLocation createBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("boat/" + model.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("chest_boat/" + model.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, BoatBOP.ModelType model, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? BoatRendererBOP.createChestBoatModelName(model) : BoatRendererBOP.createBoatModelName(model);
        ModelPart baked = context.m_174023_(modellayerlocation);
        return hasChest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }
}

