/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import fuzs.tinyskeletons.init.ModRegistry;
import fuzs.tinyskeletons.mixin.accessor.LivingEntityAccessor;
import fuzs.tinyskeletons.world.entity.ai.goal.RangedBowEasyAttackGoal;
import fuzs.tinyskeletons.world.entity.monster.BabyStray;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BabySkeleton
extends Skeleton {
    private RangedBowAttackGoal<AbstractSkeleton> bowGoal;
    private MeleeAttackGoal meleeGoal;
    private int switchWeaponCooldown;

    public BabySkeleton(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        this.m_6210_();
    }

    public float m_6143_() {
        return 0.3f;
    }

    public boolean m_6162_() {
        return true;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return super.m_6431_(pose, dimensions) * 0.534f;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42420_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    protected void m_149840_() {
        BabyStray stray = (BabyStray)this.m_21406_((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.m_203334_(), true);
        if (stray != null) {
            ((LivingEntityAccessor)((Object)stray)).tinyskeletons$callDetectEquipmentUpdates();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stray.m_8061_(slot, ItemStack.f_41583_);
            }
            stray.m_213945_(this.f_19796_, stray.m_9236_().m_6436_(stray.m_20183_()));
        }
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1048, this.m_20183_(), 0);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.switchWeaponCooldown > 0) {
                --this.switchWeaponCooldown;
            }
            if (this.switchWeaponCooldown == 0) {
                if (this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < 4.0) {
                    if (this.m_21205_().m_41720_() instanceof BowItem) {
                        this.setHandItems(this.m_21206_(), this.m_21205_());
                        this.switchWeaponCooldown = 60;
                    }
                } else if ((this.m_5448_() == null || (double)this.m_20270_((Entity)this.m_5448_()) > 8.0) && this.m_21205_().m_41720_() instanceof SwordItem) {
                    this.setHandItems(this.m_21206_(), this.m_21205_());
                    this.switchWeaponCooldown = 60;
                }
            }
        }
    }

    public void m_32164_() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            if (this.bowGoal == null || this.meleeGoal == null) {
                this.createAttackGoals();
            }
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                int minAttackInterval = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    minAttackInterval = 40;
                }
                this.bowGoal.m_25797_(minAttackInterval);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    private void setHandItems(ItemStack mainHand, ItemStack offHand) {
        this.m_21008_(InteractionHand.MAIN_HAND, mainHand);
        this.m_21008_(InteractionHand.OFF_HAND, offHand);
    }

    private void createAttackGoals() {
        this.bowGoal = new RangedBowEasyAttackGoal<BabySkeleton>(this, 1.0, 40, 60, 15.0f);
        this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public void m_8041_() {
                super.m_8041_();
                BabySkeleton.this.m_21561_(false);
            }

            public void m_8056_() {
                super.m_8056_();
                BabySkeleton.this.m_21561_(true);
            }
        };
    }
}

