/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BabyConversionHandler {
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> BABY_MOB_CONVERSIONS = Maps.newHashMap();

    public static void registerConversion(EntityType<? extends Mob> targetMob, EntityType<? extends Mob> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public static EventResult onEntitySpawn(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        EntityType<? extends Mob> entityType;
        if (spawnType != null && spawnType != MobSpawnType.COMMAND && Zombie.m_219162_((RandomSource)level.m_213780_()) && (entityType = BABY_MOB_CONVERSIONS.get(entity.m_6095_())) != null && BabyConversionHandler.createAndSpawnBabyMob(level, entityType, entity, spawnType) != null) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity target, Vec3 hitVector) {
        EntityType eggType;
        EntityType<? extends Mob> babyType;
        ItemStack stackInHand = player.m_21120_(hand);
        if (target.m_6084_() && stackInHand.m_41720_() instanceof SpawnEggItem && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((SpawnEggItem)stackInHand.m_41720_()).m_43228_(stackInHand.m_41783_()))) != null && (target.m_6095_() == babyType || target.m_6095_() == eggType)) {
            Mob mob;
            if (!level.f_46443_ && (mob = BabyConversionHandler.createAndSpawnBabyMob((ServerLevel)level, babyType, target, MobSpawnType.SPAWN_EGG)) != null) {
                BabyConversionHandler.finalizeSpawnEggMob(mob, stackInHand, player);
            }
            return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return EventResultHolder.pass();
    }

    private static void finalizeSpawnEggMob(Mob mob, ItemStack itemstack, Player player) {
        mob.m_8032_();
        if (itemstack.m_41788_()) {
            mob.m_6593_(itemstack.m_41786_());
        }
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
    }

    @Nullable
    private static Mob createAndSpawnBabyMob(ServerLevel level, EntityType<? extends Mob> entityType, Entity parent, MobSpawnType spawnReason) {
        Mob mob;
        if (parent instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)parent;
            mob = ageableMob.m_142606_(level, ageableMob);
        } else {
            mob = (Mob)entityType.m_20615_((Level)level);
        }
        if (mob == null) {
            return null;
        }
        Preconditions.checkState((boolean)mob.m_6162_(), (Object)"Baby mob must be a baby by default");
        mob.m_7678_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
        mob.f_20885_ = mob.m_146908_();
        mob.f_20883_ = mob.m_146908_();
        DifficultyInstance difficulty = new DifficultyInstance(level.m_46791_(), level.m_46468_(), 0L, level.m_46940_());
        mob.m_6518_((ServerLevelAccessor)level, difficulty, spawnReason, null, null);
        level.m_47205_((Entity)mob);
        return mob;
    }
}

