/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.timeondisplay;

import forge.net.jason13.timeondisplay.CommonClass;
import forge.net.jason13.timeondisplay.CommonConstants;
import forge.net.jason13.timeondisplay.display.ForgeConfig;
import forge.net.jason13.timeondisplay.display.ForgeDisplayKeyBinding;
import forge.net.jason13.timeondisplay.display.ForgeTimeOverlay;
import net.jason13.monolib.methods.BlockMethods;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="timeondisplay")
public class ForgeExampleMod {
    public boolean debuggingEnabled = false;
    public static boolean keyToggle = false;

    public ForgeExampleMod() {
        CommonConstants.LOG.info("Hello Forge world!");
        CommonClass.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ForgeConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onStartTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                boolean leftHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21206_());
                boolean rightHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21205_());
                if (this.debuggingEnabled || !leftHandCommand || !rightHandCommand) continue;
                this.debuggingEnabled = true;
                player.m_213846_((Component)Component.m_237113_((String)"debuggingEnabledTimeOnDisplay"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="timeondisplay", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(ForgeDisplayKeyBinding.TIMEONDISPLAY_KEY);
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (ForgeDisplayKeyBinding.TIMEONDISPLAY_KEY.m_90859_() && Minecraft.m_91087_().f_91074_ != null) {
                keyToggle = !keyToggle;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="timeondisplay", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("timeondisplay", ForgeTimeOverlay.HUD_TIME);
        }
    }
}

