/*
 * Decompiled with CFR 0.152.
 */
package common.net.jason13.enderpack.core.player;

import com.mojang.blaze3d.vertex.PoseStack;
import common.net.jason13.enderpack.CommonClient;
import common.net.jason13.enderpack.core.player.CommonBagModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EnderPackEntityLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final CommonBagModel<T> bagModel = new CommonBagModel(Minecraft.getInstance().getEntityModels().bakeLayer(CommonClient.ENDERPACK_LAYER));

    public EnderPackEntityLayer(RenderLayerParent<T, M> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag = false;
        for (ItemStack itemStack : ((Player)entity).getInventory().armor) {
            if (!itemStack.getItem().getDefaultInstance().getDisplayName().getString().toLowerCase().contains("ender pack")) continue;
            flag = true;
        }
        if (flag) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.25, 0.3125);
            EnderPackEntityLayer.renderColoredCutoutModel(this.bagModel, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, entity, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.popPose();
        }
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return CommonBagModel.ENDERPACK_TEXTURE;
    }

    private void translateToBody(LivingEntity entity, PoseStack poseStack) {
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(poseStack);
        if (entity.isBaby() && !(entity instanceof Villager)) {
            poseStack.scale(2.0f, 2.0f, 0.0f);
            poseStack.translate(1.0, 1.0, 1.0);
        }
    }
}

