/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import glitchcore.event.Event;
import glitchcore.event.EventManager;
import glitchcore.event.TickEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModPackets;
import sereneseasons.init.ModTags;
import sereneseasons.network.SyncSeasonCyclePacket;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    public static final HashMap<Level, Long> lastDayTimes = new HashMap();
    public static final HashMap<Level, Integer> updateTicks = new HashMap();
    public static final HashMap<ResourceKey<Level>, Integer> prevServerSeasonCycleTicks = new HashMap();

    public static void onLevelTick(TickEvent.Level event) {
        MinecraftServer server;
        Level level = event.getLevel();
        if (event.getPhase() != TickEvent.Phase.START || level.m_5776_() || !ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_())) {
            return;
        }
        long dayTime = level.m_46468_();
        long lastDayTime = lastDayTimes.getOrDefault(level, dayTime);
        lastDayTimes.put(level, dayTime);
        if (!level.m_46469_().m_46207_(SSGameRules.RULE_DOSEASONCYCLE)) {
            return;
        }
        if (!ModConfig.seasons.progressSeasonWhileOffline && (server = level.m_7654_()) != null && server.m_6846_().m_11309_() == 0) {
            return;
        }
        long difference = dayTime - lastDayTime;
        if (difference == 0L) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        savedData.seasonCycleTicks = Mth.m_14100_((int)(savedData.seasonCycleTicks + (int)difference), (int)SeasonTime.ZERO.getCycleDuration());
        int ticks = updateTicks.getOrDefault(level, 0);
        if (ticks >= 20) {
            SeasonHandler.sendSeasonUpdate(level);
            ticks %= 20;
        }
        updateTicks.put(level, ticks + 1);
        savedData.m_77762_();
    }

    public static void onJoinLevel(PlayerEvent.JoinLevel event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.m_9236_();
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new SyncSeasonCyclePacket((ResourceKey<Level>)level.m_46472_(), savedData.seasonCycleTicks), player2);
    }

    public static void sendSeasonUpdate(Level level) {
        if (level.m_5776_()) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        SeasonTime newTime = new SeasonTime(savedData.seasonCycleTicks);
        SeasonTime prevTime = new SeasonTime(prevServerSeasonCycleTicks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> newTime.getSeasonCycleTicks()));
        Season.SubSeason prevSeason = prevTime.getSubSeason();
        Season.TropicalSeason prevTropicalSeason = prevTime.getTropicalSeason();
        Season.SubSeason newSeason = newTime.getSubSeason();
        Season.TropicalSeason newTropicalSeason = newTime.getTropicalSeason();
        prevServerSeasonCycleTicks.put((ResourceKey<Level>)level.m_46472_(), newTime.getSeasonCycleTicks());
        if (!prevSeason.equals(newSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Standard(level, prevSeason, newSeason));
        }
        if (!prevTropicalSeason.equals(newTropicalSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Tropical(level, prevTropicalSeason, newTropicalSeason));
        }
        ModPackets.HANDLER.sendToAll((CustomPacket)new SyncSeasonCyclePacket((ResourceKey<Level>)level.m_46472_(), savedData.seasonCycleTicks), ((ServerLevel)level).m_7654_());
    }

    public static SeasonSavedData getSeasonSavedData(Level w) {
        if (w.m_5776_() || !(w instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)w;
        DimensionDataStorage saveDataManager = world.m_7726_().m_8483_();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData();
            int startingSeason = ModConfig.seasons.startingSubSeason;
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.f_46441_.m_188503_(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.m_77762_();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.m_164861_(new SavedData.Factory(defaultSaveDataSupplier, SeasonSavedData::load, DataFixTypes.LEVEL), "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(Level world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState(Level level) {
        int time = level != null ? SeasonHandlerClient.clientSeasonCycleTicks.getOrDefault(level.m_46472_(), 0) : 0;
        return new SeasonTime(time);
    }

    @Override
    public boolean usesTropicalSeasons(Holder<Biome> biome) {
        return biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES);
    }
}

