/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import sereneseasons.util.SeasonColorUtil;

public class SeasonColorHandlers {
    private static ColorResolver originalGrassColorResolver;
    private static ColorResolver originalFoliageColorResolver;

    public static void setup() {
        SeasonColorHandlers.registerGrassAndFoliageColorHandlers();
    }

    private static void registerGrassAndFoliageColorHandlers() {
        originalGrassColorResolver = BiomeColors.f_108789_;
        originalFoliageColorResolver = BiomeColors.f_108790_;
        BiomeColors.f_108789_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> biomeRegistry.m_203636_(key)).orElse(null);
            int originalColor = originalGrassColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                ISeasonState calendar = SeasonHelper.getSeasonState((Level)level);
                Enum colorProvider = biomeHolder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalGrassColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
        BiomeColors.f_108790_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> biomeRegistry.m_203636_(key)).orElse(null);
            int originalColor = originalFoliageColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                ISeasonState calendar = SeasonHelper.getSeasonState((Level)level);
                Enum colorProvider = biomeHolder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
    }
}

