/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.mixin.accessor.VillagerAccessor;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TradingPostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<TradingPostBlockEntity> {
    public static final Component MISSING_MERCHANT_COMPONENT = Component.m_237115_((String)"trading_post.no_trader_found");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final MapCodec<TradingPostBlock> CODEC = TradingPostBlock.m_306223_(TradingPostBlock::new);
    private static final VoxelShape LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG2 = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG3 = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape LEG4 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4});

    public TradingPostBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState oldState, LevelAccessor level, BlockPos newPos, BlockPos oldPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(newPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, oldState, level, newPos, oldPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockEntityType<? extends TradingPostBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.m_203334_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        int verticalRange;
        int horizontalRange;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Vec3 atCenter = Vec3.m_82512_((Vec3i)pos);
        List traders = level.m_6443_(Entity.class, new AABB(atCenter.m_82520_((double)(-(horizontalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange)), (double)(-(verticalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange)), (double)(-horizontalRange)), atCenter.m_82520_((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), TradingPostBlock::isAllowedToTrade);
        if (!traders.isEmpty()) {
            Component title;
            ContainerLevelAccess access = ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos);
            MerchantCollection merchants = new MerchantCollection(access);
            for (Entity merchant : traders) {
                if (merchant instanceof Villager) {
                    ((VillagerAccessor)merchant).callUpdateSpecialPrices(player);
                }
                merchants.addMerchant(merchant.m_19879_(), (Merchant)merchant);
            }
            merchants.m_7189_(player);
            merchants.buildOffers(merchants.getIdToOfferCountMap());
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TradingPostBlockEntity) {
                TradingPostBlockEntity blockEntity2 = (TradingPostBlockEntity)blockEntity;
                title = blockEntity2.m_5446_();
            } else {
                title = TradingPostBlockEntity.CONTAINER_COMPONENT;
            }
            OptionalInt result = player.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, inventory, containerPlayer) -> new TradingPostMenu(containerId, inventory, merchants, access), title));
            result.ifPresent(containerId -> merchants.sendMerchantData(containerId, player));
        } else {
            player.m_5661_(MISSING_MERCHANT_COMPONENT, false);
        }
        return InteractionResult.CONSUME;
    }

    public static boolean isAllowedToTrade(Entity entity) {
        LivingEntity livingEntity;
        Merchant merchant;
        if (entity.m_6095_().m_204039_(ModRegistry.CONCEALED_TRADERS_ENTITY_TYPE_TAG)) {
            return false;
        }
        if (!entity.m_6084_() || !(entity instanceof Merchant) || (merchant = (Merchant)entity).m_7962_() != null || merchant.m_6616_().isEmpty()) {
            return false;
        }
        return !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_5803_() && !livingEntity.m_6162_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof TradingPostBlockEntity) {
            TradingPostBlockEntity blockEntity2 = (TradingPostBlockEntity)blockEntity;
            blockEntity2.setCustomName(stack.m_41786_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter blockReader, BlockPos pos, PathComputationType pathType) {
        return false;
    }
}

