/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.entity.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.network.S2CBuildOffersMessage;
import fuzs.tradingpost.network.S2CMerchantDataMessage;
import fuzs.tradingpost.network.S2CRemoveMerchantsMessage;
import fuzs.tradingpost.world.entity.npc.LocalMerchant;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MerchantCollection
implements Merchant {
    private final Int2ObjectOpenHashMap<Merchant> idToMerchant = new Int2ObjectOpenHashMap();
    private final Set<MerchantOffer> disabledOffers = Sets.newHashSet();
    private final ContainerLevelAccess access;
    private MerchantOffers allOffers = new MerchantOffers();
    private Object2ObjectOpenHashMap<MerchantOffer, Merchant> offerToMerchant;
    private Merchant currentMerchant;

    public MerchantCollection() {
        this(ContainerLevelAccess.f_39287_);
    }

    public MerchantCollection(ContainerLevelAccess access) {
        this.access = access;
    }

    public void addMerchant(int entityId, Merchant merchant) {
        if (!merchant.m_6616_().isEmpty()) {
            this.idToMerchant.put(entityId, (Object)merchant);
        }
    }

    @Nullable
    public Player m_7962_() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.m_7962_();
        }
        return null;
    }

    public void m_7189_(@Nullable Player player) {
        this.idToMerchant.values().forEach(merchant -> merchant.m_7189_(player));
    }

    public MerchantOffers m_6616_() {
        return this.allOffers;
    }

    public boolean checkOffer(MerchantOffer offer) {
        return !this.disabledOffers.contains(offer);
    }

    public void m_6255_(@Nullable MerchantOffers p_213703_1_) {
        TradingPost.LOGGER.error("Set offers to stored merchants directly");
    }

    public void m_6996_(MerchantOffer offer) {
        if (this.currentMerchant != null) {
            this.currentMerchant.m_6996_(offer);
            if (!((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).teleportXp) {
                return;
            }
            this.access.m_39292_((level, pos) -> {
                Merchant patt3614$temp = this.currentMerchant;
                if (patt3614$temp instanceof Entity) {
                    Entity entity = (Entity)patt3614$temp;
                    Vec3 merchantPos = entity.m_20182_().m_82520_(0.0, 0.5, 0.0);
                    double xpWidth = 0.5;
                    double xpHeight = 0.5;
                    List xpRewards = level.m_6443_(ExperienceOrb.class, new AABB(merchantPos.m_82520_(-0.5, -0.5, -0.5), merchantPos.m_82520_(0.5, 0.5, 0.5)), Entity::m_6084_);
                    for (ExperienceOrb xpOrb : xpRewards) {
                        level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.5, (double)pos.m_123343_(), xpOrb.m_20801_()));
                        xpOrb.m_146870_();
                    }
                }
            });
        }
    }

    public void m_7713_(ItemStack stack) {
        if (this.currentMerchant != null) {
            this.currentMerchant.m_7713_(stack);
        }
    }

    public boolean m_183595_() {
        return this.access == ContainerLevelAccess.f_39287_;
    }

    public int m_7809_() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.m_7809_();
        }
        return 0;
    }

    public Merchant getCurrentMerchant() {
        return this.currentMerchant;
    }

    public boolean m_7862_() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.m_7862_();
        }
        return false;
    }

    public void m_6621_(int xpValue) {
        if (this.currentMerchant != null) {
            this.currentMerchant.m_6621_(xpValue);
        }
    }

    public boolean m_7826_() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.m_7826_();
        }
        return false;
    }

    public SoundEvent m_7596_() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.m_7596_();
        }
        return SoundEvents.f_12509_;
    }

    public int getTraderLevel() {
        if (this.currentMerchant != null) {
            Merchant merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getMerchantLevel();
            }
            if (merchant instanceof VillagerDataHolder) {
                return ((VillagerDataHolder)merchant).m_7141_().m_35576_();
            }
        }
        return 0;
    }

    @Nullable
    public Component getDisplayName() {
        if (this.currentMerchant != null) {
            Merchant merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getDisplayName();
            }
            if (merchant instanceof Entity) {
                return ((Entity)merchant).m_5446_();
            }
        }
        return null;
    }

    public boolean updateAvailableMerchants(int containerId, BlockPos pos, Player player, boolean testRange) {
        IntOpenHashSet toRemove = new IntOpenHashSet();
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            if (!(entry.getValue() instanceof Entity) || ((Merchant)entry.getValue()).m_7962_() == player && (!testRange || this.traderInRange((Entity)entry.getValue(), pos))) continue;
            toRemove.add(((Integer)entry.getKey()).intValue());
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this::removeMerchant);
            TradingPost.NETWORK.sendTo((MessageV2)new S2CRemoveMerchantsMessage(containerId, (IntSet)toRemove), (ServerPlayer)player);
        }
        return !this.idToMerchant.isEmpty();
    }

    private boolean traderInRange(Entity entity, BlockPos pos) {
        return this.traderInRange(entity, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    private boolean traderInRange(Entity entity, double posX, double posY, double posZ) {
        return Math.abs(entity.m_20185_() - posX) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange && Math.abs(entity.m_20186_() - posY) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange && Math.abs(entity.m_20189_() - posZ) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange;
    }

    public void removeMerchant(int merchantId) {
        Merchant merchant = (Merchant)this.idToMerchant.get(merchantId);
        if (merchant != null) {
            this.disabledOffers.addAll((Collection<MerchantOffer>)merchant.m_6616_());
            this.idToMerchant.remove(merchantId);
            merchant.m_7189_(null);
            if (this.currentMerchant == merchant) {
                this.currentMerchant = null;
            }
        }
    }

    public void setActiveOffer(MerchantOffer offer) {
        if (this.offerToMerchant != null) {
            this.currentMerchant = offer != null ? (Merchant)this.offerToMerchant.get((Object)offer) : null;
        }
    }

    public void sendMerchantData(int containerId, Player player) {
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            Merchant merchant = (Merchant)entry.getValue();
            Component merchantTitle = merchant instanceof Entity ? ((Entity)merchant).m_5446_() : TradingPostBlockEntity.CONTAINER_COMPONENT;
            int merchantLevel = merchant instanceof VillagerDataHolder ? ((VillagerDataHolder)merchant).m_7141_().m_35576_() : 0;
            S2CMerchantDataMessage message = new S2CMerchantDataMessage(containerId, (Integer)entry.getKey(), merchantTitle, merchant.m_6616_(), merchantLevel, merchant.m_7809_(), merchant.m_7826_(), merchant.m_7862_());
            TradingPost.NETWORK.sendTo((MessageV2)message, (ServerPlayer)player);
        }
        TradingPost.NETWORK.sendTo((MessageV2)new S2CBuildOffersMessage(containerId, this.getIdToOfferCountMap()), (ServerPlayer)player);
    }

    public Int2IntOpenHashMap getIdToOfferCountMap() {
        return this.idToMerchant.int2ObjectEntrySet().stream().collect(Collectors.toMap(Int2ObjectMap.Entry::getIntKey, entry -> ((Merchant)entry.getValue()).m_6616_().size(), (o1, o2) -> o1, Int2IntOpenHashMap::new));
    }

    public void buildOffers(Int2IntOpenHashMap idToOfferCount) {
        ArrayList sortedEntries = Lists.newArrayList((Iterable)idToOfferCount.int2IntEntrySet());
        sortedEntries.sort(Comparator.comparingInt(Int2IntMap.Entry::getIntKey));
        TradingPostOffers allOffers = new TradingPostOffers(this.disabledOffers);
        for (Int2IntMap.Entry entry : sortedEntries) {
            Merchant merchant = (Merchant)this.idToMerchant.get(entry.getIntKey());
            for (int i = 0; i < entry.getIntValue(); ++i) {
                MerchantOffer offer;
                if (merchant != null && i < merchant.m_6616_().size()) {
                    offer = (MerchantOffer)merchant.m_6616_().get(i);
                } else {
                    offer = MerchantCollection.fakeOffer();
                    this.disabledOffers.add(offer);
                }
                allOffers.add(offer);
            }
        }
        this.allOffers = allOffers;
        this.buildOfferToMerchantMap();
    }

    private void buildOfferToMerchantMap() {
        Object2ObjectOpenHashMap offerToMerchant = new Object2ObjectOpenHashMap();
        for (Merchant merchant : this.idToMerchant.values()) {
            merchant.m_6616_().forEach(offer -> offerToMerchant.put(offer, (Object)merchant));
        }
        this.offerToMerchant = offerToMerchant;
    }

    private static MerchantOffer fakeOffer() {
        return new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, -1, -1, 0.0f);
    }
}

