/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.config;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;

public class ServerConfig
implements ConfigCore {
    @Config(description={"Range on xz plane trading post should search for merchants."})
    @Config.IntRange(min=1, max=96)
    public int horizontalRange = 24;
    @Config(description={"Range on y axis trading post should search for merchants."})
    @Config.IntRange(min=1, max=96)
    public int verticalRange = 16;
    @Config(description={"Disable traders on the trading screen when they wander out of range."})
    public boolean enforceRange = false;
    @Config(description={"Teleport xp from trading from villagers on top of the trading post."})
    public boolean teleportXp = true;
    @Config(name="close_empty_screen", description={"Close trading post interface when all traders have become unavailable."})
    public boolean closeScreen = true;
    @Config(name="trader_blacklist", description={"Trader entities disabled from being found by the trading post.", "Modders may add their own incompatible trader entities via the \"tradingpost:blacklisted_traders\" entity tag.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> traderBlacklistRaw = Lists.newArrayList();
    public ConfigDataSet<EntityType<?>> traderBlacklist;

    public void afterConfigReload() {
        this.traderBlacklist = ConfigDataSet.from((ResourceKey)Registries.f_256939_, this.traderBlacklistRaw, (Class[])new Class[0]);
    }
}

