/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.mixin.client.accessor.ButtonAccessor;
import fuzs.tradingpost.mixin.client.accessor.MerchantScreenAccessor;
import fuzs.tradingpost.mixin.client.accessor.TradeOfferButtonAccessor;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class TradingPostScreen
extends MerchantScreen {
    public static final ResourceLocation MAGNIFYING_GLASS_LOCATION = TradingPost.id("container/villager/magnifying_glass");
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("textures/gui/container/villager.png");
    private static final ResourceLocation OUT_OF_STOCK_SPRITE = new ResourceLocation("container/villager/out_of_stock");
    private static final ResourceLocation DISCOUNT_STRIKETHRUOGH_SPRITE = new ResourceLocation("container/villager/discount_strikethrough");
    private static final ResourceLocation CREATIVE_INVENTORY_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tab_item_search.png");
    public static final Component DEPRECATED_TRADE_COMPONENT = Component.m_237115_((String)"merchant.deprecated");
    public static final Component MERCHANT_UNAVAILABLE_COMPONENT = Component.m_237115_((String)"trading_post.trader_gone");
    private Button[] tradeOfferButtons = new Button[7];
    private EditBox searchBox;
    private boolean ignoreTextInput;

    public TradingPostScreen(MerchantMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tradeOfferButtons = (Button[])this.f_169369_.stream().filter(Button.class::isInstance).limit(7L).map(Button.class::cast).toArray(Button[]::new);
        Objects.checkIndex(6, this.tradeOfferButtons.length);
        for (Button tradeOfferButton : this.tradeOfferButtons) {
            ((ButtonAccessor)tradeOfferButton).tradingpost$setOnPress(button -> {
                MerchantScreenAccessor accessor = (MerchantScreenAccessor)((Object)this);
                int shopItem = ((TradeOfferButtonAccessor)button).tradingpost$getIndex() + accessor.tradingpost$getScrollOff();
                MerchantOffers offers = this.getMenu().m_40075_();
                accessor.tradingpost$setShopItem(shopItem);
                this.getMenu().m_40063_(shopItem);
                this.getMenu().getTraders().setActiveOffer((MerchantOffer)offers.get(shopItem));
                this.getMenu().m_40072_(shopItem);
                this.f_96541_.m_91403_().m_295327_((Packet)new ServerboundSelectTradePacket(offers instanceof TradingPostOffers ? ((TradingPostOffers)offers).getOrigShopItem(shopItem) : shopItem));
            });
        }
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 13, this.f_97736_ + 6, 80, 9, TradingPostBlockEntity.CONTAINER_COMPONENT);
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String lastSearch = this.searchBox.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.searchBox.m_94144_(lastSearch);
        if (!this.searchBox.m_94155_().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component title = this.getMenu().getTraders().getDisplayName();
        if (title != null) {
            int traderLevel = ((MerchantMenu)this.f_97732_).m_40071_();
            if (traderLevel > 0 && traderLevel <= 5 && ((MerchantMenu)this.f_97732_).m_40076_()) {
                title = title.m_6881_().m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)("merchant.level." + traderLevel)));
            }
        } else {
            title = this.f_96539_;
        }
        guiGraphics.m_280614_(this.f_96547_, title, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTime) {
        MerchantOffers merchantoffers = this.getMenu().m_40075_();
        this.setButtonsActive(merchantoffers);
        int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
        Slot hoveredSlot = this.f_97734_;
        this.lock(true, merchantoffers.size(), null);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTime);
        this.lock(false, scrollOff, hoveredSlot);
        if (!merchantoffers.isEmpty()) {
            MerchantOffer merchantoffer;
            int shopItemIndex = ((MerchantScreenAccessor)((Object)this)).tradingpost$getShopItem();
            if (shopItemIndex >= 0 && shopItemIndex < merchantoffers.size() && (merchantoffer = (MerchantOffer)merchantoffers.get(shopItemIndex)).m_45380_()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_295520_(OUT_OF_STOCK_SPRITE, this.f_97735_ + 83 + 99, this.f_97736_ + 35, 0, 28, 21);
            }
            int posX = this.f_97735_ + 5;
            int posY = this.f_97736_ + 16 + 2;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VILLAGER_LOCATION);
            ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderScroller(guiGraphics, this.f_97735_, this.f_97736_, merchantoffers);
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer2 = (MerchantOffer)merchantoffers.get(i);
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderButtonArrows(guiGraphics, merchantoffer2, this.f_97735_, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    guiGraphics.m_280509_(posX, posY, posX + 88, posY + 20, 0x30FF0000);
                }
                ItemStack baseCostA = merchantoffer2.m_45352_();
                ItemStack costA = merchantoffer2.m_45358_();
                ItemStack costB = merchantoffer2.m_45364_();
                ItemStack result = merchantoffer2.m_45368_();
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    RenderSystem.depthFunc((int)516);
                    guiGraphics.m_280509_(posX, posY, posX + 88, posY + 20, 0x30FFFFFF);
                    RenderSystem.depthFunc((int)515);
                }
                this.renderAndDecorateCostA(guiGraphics, posX, posY, baseCostA, costA);
                if (!costB.m_41619_()) {
                    guiGraphics.m_280203_(costB, posX + 35, posY + 1);
                    guiGraphics.m_280370_(this.f_96547_, costB, posX + 35, posY + 1);
                }
                guiGraphics.m_280203_(result, posX + 68, posY + 1);
                guiGraphics.m_280370_(this.f_96547_, result, posX + 68, posY + 1);
                guiGraphics.m_280168_().m_85849_();
                posY += 20;
            }
            MerchantOffer activeOffer = (MerchantOffer)merchantoffers.get(shopItemIndex);
            if (this.getMenu().m_40076_()) {
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderProgressBar(guiGraphics, this.f_97735_, this.f_97736_, activeOffer);
            }
            if (activeOffer.m_45380_() && this.m_6774_(186, 35, 22, 21, mouseX, mouseY) && this.getMenu().m_40074_()) {
                guiGraphics.m_280557_(this.f_96547_, DEPRECATED_TRADE_COMPONENT, mouseX, mouseY);
            }
            posY = this.f_97736_ + 16 + 2;
            int merchantoffersSize2 = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize2; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer3 = (MerchantOffer)merchantoffers.get(i);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer3) && this.m_6774_(posX, posY, 88, 19, mouseX + this.f_97735_, mouseY + this.f_97736_)) {
                    guiGraphics.m_280557_(this.f_96547_, MERCHANT_UNAVAILABLE_COMPONENT, mouseX, mouseY);
                }
                posY += 20;
            }
            RenderSystem.enableDepthTest();
        }
        Button[] offerButtons = this.tradeOfferButtons;
        int offerButtonsLength = offerButtons.length;
        for (int i = 0; i < offerButtonsLength; ++i) {
            Button button = offerButtons[i];
            if (button.f_93623_ && button.m_198029_()) {
                ((TradeOfferButtonAccessor)button).tradingpost$callRenderToolTip(guiGraphics, mouseX, mouseY);
            }
            button.f_93624_ = i < this.getMenu().m_40075_().size();
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderAndDecorateCostA(GuiGraphics guiGraphics, int posX, int posY, ItemStack baseCostA, ItemStack costA) {
        guiGraphics.m_280203_(costA, posX + 5, posY + 1);
        if (baseCostA.m_41613_() == costA.m_41613_()) {
            guiGraphics.m_280370_(this.f_96547_, costA, posX + 5, posY + 1);
        } else {
            guiGraphics.m_280302_(this.f_96547_, baseCostA, posX + 5, posY + 1, baseCostA.m_41613_() == 1 ? "1" : null);
            guiGraphics.m_280302_(this.f_96547_, costA, posX + 5 + 14, posY + 1, costA.m_41613_() == 1 ? "1" : null);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            guiGraphics.m_295520_(DISCOUNT_STRIKETHRUOGH_SPRITE, posX + 5 + 7, posY + 1 + 12, 0, 9, 2);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void setButtonsActive(MerchantOffers merchantoffers) {
        if (!merchantoffers.isEmpty()) {
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer offer = (MerchantOffer)merchantoffers.get(i);
                this.tradeOfferButtons[i - scrollOff].f_93623_ = this.getMenu().getTraders().checkOffer(offer);
            }
        }
    }

    private void lock(boolean lockOffers, int newScrollOff, Slot newHoveredSlot) {
        this.getMenu().lockOffers(lockOffers);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(newScrollOff);
        this.f_97734_ = newHoveredSlot;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.m_280398_(CREATIVE_INVENTORY_LOCATION, this.f_97735_ + 11, this.f_97736_ + 4, 0, 80.0f, 4.0f, 90, 12, 256, 256);
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_295520_(MAGNIFYING_GLASS_LOCATION, this.f_97735_, this.f_97736_ + 4, 0, 16, 16);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VILLAGER_LOCATION);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseKey) {
        if (this.searchBox.m_6375_(mouseX, mouseY, mouseKey)) {
            this.searchBox.m_93692_(true);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseKey);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifierKeys) {
        this.ignoreTextInput = false;
        String lastSearch = this.searchBox.m_94155_().trim();
        if (this.searchBox.m_7933_(keyCode, scanCode, modifierKeys)) {
            if (!Objects.equals(this.searchBox.m_94155_().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && !this.searchBox.m_93696_()) {
            this.ignoreTextInput = true;
            this.searchBox.m_93692_(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifierKeys);
    }

    public boolean m_5534_(char typedChar, int modifierKeys) {
        String lastSearch = this.searchBox.m_94155_().trim();
        if (!this.ignoreTextInput && this.searchBox.m_5534_(typedChar, modifierKeys)) {
            if (!Objects.equals(this.searchBox.m_94155_().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        return super.m_5534_(typedChar, modifierKeys);
    }

    public void refreshSearchResults() {
        MerchantOffers merchantOffers = this.getMenu().m_40075_();
        if (!(merchantOffers instanceof TradingPostOffers)) {
            return;
        }
        TradingPostOffers offers = (TradingPostOffers)merchantOffers;
        String query = this.searchBox.m_94155_().trim();
        if (query.isEmpty()) {
            offers.clearFilter();
        } else {
            SearchTree isearchtree = this.f_96541_.m_231372_(TradingPostClient.OFFER_SEARCH_TREE);
            offers.setFilter(isearchtree.m_6293_(query.toLowerCase(Locale.ROOT)));
        }
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(0);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setShopItem(0);
        this.getMenu().m_40063_(-1);
        this.getMenu().getTraders().setActiveOffer(null);
        this.getMenu().clearPaymentSlots();
        TradingPost.NETWORK.sendToServer((MessageV2)new C2SClearSlotsMessage());
    }

    public TradingPostMenu getMenu() {
        return (TradingPostMenu)super.m_6262_();
    }
}

