/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.FuelBurnTimesContext;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.network.S2CBuildOffersMessage;
import fuzs.tradingpost.network.S2CMerchantDataMessage;
import fuzs.tradingpost.network.S2CRemoveMerchantsMessage;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradingPost
implements ModConstructor {
    public static final String MOD_ID = "tradingpost";
    public static final String MOD_NAME = "Trading Post";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Trading Post");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"tradingpost", (boolean)false);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"tradingpost").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        TradingPost.registerMessages();
    }

    private static void registerMessages() {
        NETWORK.registerClientbound(S2CMerchantDataMessage.class, S2CMerchantDataMessage::new);
        NETWORK.registerClientbound(S2CRemoveMerchantsMessage.class, S2CRemoveMerchantsMessage::new);
        NETWORK.registerClientbound(S2CBuildOffersMessage.class, S2CBuildOffersMessage::new);
        NETWORK.registerServerbound(C2SClearSlotsMessage.class, C2SClearSlotsMessage::new);
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener(CreativeModeTabs.f_256791_, (itemDisplayParameters, output) -> output.m_246326_((ItemLike)ModRegistry.TRADING_POST_ITEM.m_203334_()));
    }

    public void onRegisterFuelBurnTimes(FuelBurnTimesContext context) {
        context.registerFuel(300, new ItemLike[]{(ItemLike)ModRegistry.TRADING_POST_BLOCK.m_203334_()});
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

