/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.network;

import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.api.config.Synced;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SyncConfigMessage<TData> {
    private final TData data;

    public SyncConfigMessage(TData data) {
        this.data = data;
    }

    public TData getData() {
        return this.data;
    }

    public static <TData> Supplier<TData> createDeepCopyFactory(Supplier<TData> from, Supplier<TData> factory) {
        return () -> {
            Object to = factory.get();
            ConfigReflection.deepCopy(from.get(), to);
            return to;
        };
    }

    public static <TData, TMessage extends SyncConfigMessage<TData>> Function<FriendlyByteBuf, TMessage> createDecoder(Class<?> clazz, Function<TData, TMessage> messageFactory, Supplier<TData> dataFactory) {
        return buf -> {
            Object data = dataFactory.get();
            SyncConfigMessage.readSyncedFields(buf, data, false);
            return (SyncConfigMessage)messageFactory.apply(data);
        };
    }

    private static <TData> void readSyncedFields(FriendlyByteBuf buf, TData data, boolean forceSynced) {
        List<Field> syncedFields = !forceSynced ? ConfigReflection.getSyncedFields(data.getClass()) : Arrays.asList(data.getClass().getFields());
        syncedFields.sort(Comparator.comparing(Field::getName));
        for (Field field : syncedFields) {
            Class<?> type = field.getType();
            try {
                Object value = SyncConfigMessage.readValue(buf, data, field, type);
                field.set(data, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static <TData> Object readValue(FriendlyByteBuf buf, TData data, Field field, Class<?> type) throws IllegalAccessException {
        AbstractCollection value;
        if (String.class.isAssignableFrom(type)) {
            value = buf.m_130277_();
        } else if (ResourceLocation.class.isAssignableFrom(type)) {
            value = buf.m_130281_();
        } else if (Enum.class.isAssignableFrom(type)) {
            value = type.getEnumConstants()[buf.readByte()];
        } else if (Integer.TYPE.isAssignableFrom(type)) {
            value = buf.readInt();
        } else if (Float.TYPE.isAssignableFrom(type)) {
            value = Float.valueOf(buf.readFloat());
        } else if (Double.TYPE.isAssignableFrom(type)) {
            value = buf.readDouble();
        } else if (Boolean.TYPE.isAssignableFrom(type)) {
            value = buf.readBoolean();
        } else if (Long.TYPE.isAssignableFrom(type)) {
            value = buf.readLong();
        } else if (List.class.isAssignableFrom(type)) {
            int count = buf.m_130242_();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < count; ++i) {
                list.add(SyncConfigMessage.readValue(buf, data, field, field.getAnnotation(ExpectedType.class).value()));
            }
            value = list;
        } else if (Set.class.isAssignableFrom(type)) {
            int count = buf.m_130242_();
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < count; ++i) {
                set.add(SyncConfigMessage.readValue(buf, data, field, field.getAnnotation(ExpectedType.class).value()));
            }
            value = set;
        } else {
            value = field.get(data);
            SyncConfigMessage.readSyncedFields(buf, value, field.getAnnotation(Synced.class) != null);
        }
        return value;
    }

    public static <TData, TMessage extends SyncConfigMessage<TData>> BiConsumer<TMessage, FriendlyByteBuf> createEncoder(Class<TData> clazz) {
        return (message, buf) -> {
            Object data = message.getData();
            SyncConfigMessage.writeSyncedFields(buf, data, false);
        };
    }

    private static <TData> void writeSyncedFields(FriendlyByteBuf buf, TData data, boolean forceSynced) {
        List<Field> syncedFields = !forceSynced ? ConfigReflection.getSyncedFields(data.getClass()) : Arrays.asList(data.getClass().getFields());
        syncedFields.sort(Comparator.comparing(Field::getName));
        for (Field field : syncedFields) {
            Class<?> type = field.getType();
            try {
                Object value = field.get(data);
                SyncConfigMessage.writeValue(buf, data, field, type, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static <TData> void writeValue(FriendlyByteBuf buf, TData data, Field field, Class<?> type, Object value) throws IllegalAccessException {
        if (String.class.isAssignableFrom(type)) {
            buf.m_130070_((String)value);
        } else if (ResourceLocation.class.isAssignableFrom(type)) {
            buf.m_130085_((ResourceLocation)value);
        } else if (Enum.class.isAssignableFrom(type)) {
            buf.writeByte(((Enum)value).ordinal());
        } else if (Integer.TYPE.isAssignableFrom(type)) {
            buf.writeInt(((Integer)value).intValue());
        } else if (Float.TYPE.isAssignableFrom(type)) {
            buf.writeFloat(((Float)value).floatValue());
        } else if (Double.TYPE.isAssignableFrom(type)) {
            buf.writeDouble(((Double)value).doubleValue());
        } else if (Boolean.TYPE.isAssignableFrom(type)) {
            buf.writeBoolean(((Boolean)value).booleanValue());
        } else if (Long.TYPE.isAssignableFrom(type)) {
            buf.writeLong(((Long)value).longValue());
        } else if (List.class.isAssignableFrom(type)) {
            List list = (List)value;
            buf.m_130130_(list.size());
            for (Object element : list) {
                SyncConfigMessage.writeValue(buf, data, field, field.getAnnotation(ExpectedType.class).value(), element);
            }
        } else if (Set.class.isAssignableFrom(type)) {
            Set set = (Set)value;
            buf.m_130130_(set.size());
            for (Object element : set) {
                SyncConfigMessage.writeValue(buf, data, field, field.getAnnotation(ExpectedType.class).value(), element);
            }
        } else {
            SyncConfigMessage.writeSyncedFields(buf, field.get(data), field.getAnnotation(Synced.class) != null);
        }
    }

    public static <TMessage extends SyncConfigMessage<TData>, TData extends BalmConfigData> void register(ResourceLocation resourceLocation, Class<TMessage> messageClass, Function<TData, TMessage> messageFactory, Class<TData> dataClass, Supplier<TData> dataFactory) {
        Supplier<BalmConfigData> copyFactory = SyncConfigMessage.createDeepCopyFactory(() -> Balm.getConfig().getBackingConfig(dataClass), dataFactory);
        Balm.getNetworking().registerClientboundPacket(resourceLocation, messageClass, (message, buf) -> {
            BalmConfigData data = (BalmConfigData)message.getData();
            SyncConfigMessage.writeSyncedFields(buf, data, false);
        }, buf -> {
            BalmConfigData data = (BalmConfigData)copyFactory.get();
            SyncConfigMessage.readSyncedFields(buf, data, false);
            return (SyncConfigMessage)messageFactory.apply(data);
        }, Balm.getConfig()::handleSync);
    }
}

