/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.networking.packets;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import com.natamus.starterkit_common_neoforge.config.ConfigHandler;
import com.natamus.starterkit_common_neoforge.functions.StarterCheckFunctions;
import com.natamus.starterkit_common_neoforge.functions.StarterGearFunctions;
import com.natamus.starterkit_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ToServerSendKitChoicePacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("starterkit", "to_server_send_kit_choice_packet");
    private static String kitName;

    public ToServerSendKitChoicePacket(String kitNameIn) {
        kitName = kitNameIn;
    }

    public static ToServerSendKitChoicePacket decode(FriendlyByteBuf buf) {
        String kitNameIn = buf.readUtf();
        return new ToServerSendKitChoicePacket(kitNameIn);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(kitName);
    }

    public static void handle(PacketContext<ToServerSendKitChoicePacket> ctx) {
        Player player;
        if (ctx.side().equals((Object)Side.SERVER) && StarterCheckFunctions.shouldPlayerReceiveStarterKit(player = ctx.sender())) {
            Level level = player.level();
            if (level.getServer().isDedicatedServer()) {
                if (ConfigHandler.announcePlayerKitChoiceInDedicatedServer) {
                    MessageFunctions.broadcastMessage((Level)level, (MutableComponent)Component.literal((String)(player.getName().getString() + " has chosen the '" + Util.formatKitName(kitName) + "' kit!")).withStyle(ChatFormatting.DARK_GREEN));
                }
            } else {
                MessageFunctions.sendMessage((Player)player, (String)("You have been given the '" + Util.formatKitName(kitName) + "' starter kit."), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            }
            StarterGearFunctions.giveStarterKit(player, null, kitName);
        }
    }
}

