/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.networking.packets;

import com.google.common.collect.Maps;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import com.natamus.starterkit_common_neoforge.data.VariablesClient;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ToClientReceiveKitDataPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("starterkit", "to_client_receive_kit_data_packet");
    private static HashMap<String, String> packetStarterGearEntries;
    private static HashMap<String, String> packetStarterKitDescriptions;

    public ToClientReceiveKitDataPacket(HashMap<String, String> entriesIn, HashMap<String, String> descriptionsIn) {
        packetStarterGearEntries = entriesIn;
        packetStarterKitDescriptions = descriptionsIn;
    }

    public static ToClientReceiveKitDataPacket decode(FriendlyByteBuf buf) {
        HashMap entriesIn = (HashMap)buf.readMap(Maps::newHashMapWithExpectedSize, FriendlyByteBuf::readUtf, FriendlyByteBuf::readUtf);
        HashMap descriptionsIn = (HashMap)buf.readMap(Maps::newHashMapWithExpectedSize, FriendlyByteBuf::readUtf, FriendlyByteBuf::readUtf);
        return new ToClientReceiveKitDataPacket(entriesIn, descriptionsIn);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeMap(packetStarterGearEntries, (a, b) -> a.writeUtf(b), (a, b) -> a.writeUtf(b));
        buf.writeMap(packetStarterKitDescriptions, (a, b) -> a.writeUtf(b), (a, b) -> a.writeUtf(b));
    }

    public static void handle(PacketContext<ToClientReceiveKitDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            VariablesClient.cachedStarterGearEntries = packetStarterGearEntries;
            VariablesClient.cachedStarterKitDescriptions = packetStarterKitDescriptions;
            VariablesClient.openChooseKitScreen = true;
        }
    }
}

