/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.inventory;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_neoforge.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_neoforge.config.ConfigHandler;
import com.natamus.starterkit_common_neoforge.data.ConstantsClient;
import com.natamus.starterkit_common_neoforge.data.VariablesClient;
import com.natamus.starterkit_common_neoforge.functions.StarterClientFunctions;
import com.natamus.starterkit_common_neoforge.inventory.StarterKitEffectRenderingInventoryScreen;
import com.natamus.starterkit_common_neoforge.inventory.StarterKitInventoryMenu;
import com.natamus.starterkit_common_neoforge.networking.packets.ToServerSendKitChoicePacket;
import com.natamus.starterkit_common_neoforge.util.Util;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StarterKitInventoryScreen
extends StarterKitEffectRenderingInventoryScreen<StarterKitInventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public StarterKitInventoryScreen(Player player) {
        super(new StarterKitInventoryMenu(player), VariablesClient.cachedStarterKitInventory, (Component)Component.literal((String)Util.formatKitName(VariablesClient.cachedStarterKitName)).withStyle(ChatFormatting.BOLD));
        this.minecraft = Minecraft.getInstance();
        if (player == null) {
            return;
        }
        Inventory kitInventory = VariablesClient.cachedStarterKitInventory;
        if (kitInventory == null) {
            return;
        }
        NonNullList itemList = kitInventory.items;
        NonNullList armourList = kitInventory.armor;
        NonNullList offhandList = kitInventory.offhand;
        player.getInventory().selected = 0;
        player.setItemSlot(EquipmentSlot.HEAD, (ItemStack)armourList.get(3));
        player.setItemSlot(EquipmentSlot.CHEST, (ItemStack)armourList.get(2));
        player.setItemSlot(EquipmentSlot.LEGS, (ItemStack)armourList.get(1));
        player.setItemSlot(EquipmentSlot.FEET, (ItemStack)armourList.get(0));
        player.setItemSlot(EquipmentSlot.MAINHAND, (ItemStack)itemList.get(0));
        player.setItemSlot(EquipmentSlot.OFFHAND, (ItemStack)offhandList.get(0));
        ConstantsClient.mc.options.hideGui = true;
    }

    @Override
    public void containerTick() {
    }

    @Override
    protected void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.setupButtons();
    }

    private void setupButtons() {
        Button previousKitButton = Button.builder((Component)Component.literal((String)" < "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.minecraft.player, false)).bounds(this.width / 2 + 13, this.height / 2 - 21, 30, 16).build();
        Button nextKitButton = Button.builder((Component)Component.literal((String)" > "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.minecraft.player, true)).bounds(this.width / 2 + 47, this.height / 2 - 21, 30, 16).build();
        Button chooseKitButton = Button.builder((Component)Component.literal((String)"Choose Starter Kit"), button -> {
            StarterClientFunctions.clearPriorEquipmentCache();
            Dispatcher.sendToServer((Object)new ToServerSendKitChoicePacket(VariablesClient.cachedStarterKitName));
            ConstantsClient.mc.setScreen(null);
        }).bounds(this.width / 2 - 60, this.height / 2 + 88, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)previousKitButton);
        this.addRenderableWidget((GuiEventListener)nextKitButton);
        this.addRenderableWidget((GuiEventListener)chooseKitButton);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String playerName = "";
        if (this.minecraft.player != null) {
            playerName = this.minecraft.player.getName().getString();
        }
        String headerString = ConfigHandler.chooseKitText.replace("%s", playerName);
        if (playerName.equals("")) {
            headerString = headerString.replace(", p", "P");
        }
        MutableComponent headerComponent = Component.literal((String)headerString).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
        int headerWidth = this.font.width((FormattedText)headerComponent);
        guiGraphics.drawString(this.font, (Component)headerComponent, -((headerWidth - this.imageWidth) / 2), -16, 0, true);
        String fullKitName = Util.formatKitName(VariablesClient.cachedStarterKitName);
        Object kitName = fullKitName;
        while (this.font.width((String)kitName) > 88) {
            kitName = Util.removeLastChar((String)kitName);
        }
        if (!fullKitName.equalsIgnoreCase((String)kitName)) {
            kitName = (String)kitName + "...";
        }
        guiGraphics.drawString(this.font, (String)kitName, 79, 7, 0x404040, false);
        if (VariablesClient.cachedStarterKitDescriptions.containsKey(VariablesClient.cachedStarterKitName)) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            String kitDescription = VariablesClient.cachedStarterKitDescriptions.get(VariablesClient.cachedStarterKitName);
            MutableComponent descriptionComponent = Component.literal((String)kitDescription);
            poseStack.scale(0.66f, 0.66f, 0.66f);
            int y = 28;
            List descriptionLines = ComponentRenderUtils.wrapComponents((FormattedText)descriptionComponent, (int)136, (Font)this.minecraft.font);
            for (FormattedCharSequence line : descriptionLines) {
                int x = 120;
                if (y > 28) {
                    x -= 2;
                }
                if (y > 70 && descriptionLines.size() > 6) {
                    guiGraphics.drawString(this.font, "...", x + 132, y, 0x404040, false);
                }
                guiGraphics.drawString(this.font, line, x, y, 0x404040, false);
                if ((y += 10) <= 80) continue;
                break;
            }
            poseStack.popPose();
        }
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(INVENTORY_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        StarterKitInventoryScreen.renderEntityInInventoryFollowsMouse(guiGraphics, i + 26, j + 8, i + 75, j + 78, 30, 0.0625f, this.xMouse, this.yMouse, (LivingEntity)this.minecraft.player);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)(x1 + x2) / 2.0f;
        float g = (float)(y1 + y2) / 2.0f;
        guiGraphics.enableScissor(x1, y1, x2, y2);
        float h = (float)Math.atan((f - mouseX) / 40.0f);
        float i = (float)Math.atan((g - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.yBodyRot;
        float k = entity.getYRot();
        float l = entity.getXRot();
        float m = entity.yHeadRotO;
        float n = entity.yHeadRot;
        entity.yBodyRot = 180.0f + h * 20.0f;
        entity.setYRot(180.0f + h * 40.0f);
        entity.setXRot(-i * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        Vector3f vector3f = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + yOffset, 0.0f);
        StarterKitInventoryScreen.renderEntityInInventory(guiGraphics, f, g, scale, vector3f, quaternionf, quaternionf2, entity);
        entity.yBodyRot = j;
        entity.setYRot(k);
        entity.setXRot(l);
        entity.yHeadRotO = m;
        entity.yHeadRot = n;
        guiGraphics.disableScissor();
    }

    public static void renderEntityInInventory(GuiGraphics guiGraphics, float x, float y, int scale, Vector3f translate, Quaternionf pose, @Nullable Quaternionf cameraOrientation, LivingEntity entity) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x, (double)y, 50.0);
        guiGraphics.pose().mulPoseMatrix(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        guiGraphics.pose().translate(translate.x, translate.y, translate.z);
        guiGraphics.pose().mulPose(pose);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityRenderDispatcher.overrideCameraOrientation(cameraOrientation);
        }
        entityRenderDispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0));
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    @Override
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return !this.widthTooNarrow && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return !this.widthTooNarrow && super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void slotClicked(@NotNull Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
    }

    public void recipesUpdated() {
    }
}

