/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.inventory;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_forge.config.ConfigHandler;
import com.natamus.starterkit_common_forge.data.ConstantsClient;
import com.natamus.starterkit_common_forge.data.VariablesClient;
import com.natamus.starterkit_common_forge.functions.StarterClientFunctions;
import com.natamus.starterkit_common_forge.inventory.StarterKitEffectRenderingInventoryScreen;
import com.natamus.starterkit_common_forge.inventory.StarterKitInventoryMenu;
import com.natamus.starterkit_common_forge.networking.packets.ToServerSendKitChoicePacket;
import com.natamus.starterkit_common_forge.util.Util;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StarterKitInventoryScreen
extends StarterKitEffectRenderingInventoryScreen<StarterKitInventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public StarterKitInventoryScreen(Player player) {
        super(new StarterKitInventoryMenu(player), VariablesClient.cachedStarterKitInventory, (Component)Component.m_237113_((String)Util.formatKitName(VariablesClient.cachedStarterKitName)).m_130940_(ChatFormatting.BOLD));
        this.f_96541_ = Minecraft.m_91087_();
        if (player == null) {
            return;
        }
        Inventory kitInventory = VariablesClient.cachedStarterKitInventory;
        if (kitInventory == null) {
            return;
        }
        NonNullList itemList = kitInventory.f_35974_;
        NonNullList armourList = kitInventory.f_35975_;
        NonNullList offhandList = kitInventory.f_35976_;
        player.m_150109_().f_35977_ = 0;
        player.m_8061_(EquipmentSlot.HEAD, (ItemStack)armourList.get(3));
        player.m_8061_(EquipmentSlot.CHEST, (ItemStack)armourList.get(2));
        player.m_8061_(EquipmentSlot.LEGS, (ItemStack)armourList.get(1));
        player.m_8061_(EquipmentSlot.FEET, (ItemStack)armourList.get(0));
        player.m_8061_(EquipmentSlot.MAINHAND, (ItemStack)itemList.get(0));
        player.m_8061_(EquipmentSlot.OFFHAND, (ItemStack)offhandList.get(0));
        ConstantsClient.mc.f_91066_.f_92062_ = true;
    }

    @Override
    public void containerTick() {
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.setupButtons();
    }

    private void setupButtons() {
        Button previousKitButton = Button.m_253074_((Component)Component.m_237113_((String)" < "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.f_96541_.f_91074_, false)).m_252987_(this.f_96543_ / 2 + 13, this.f_96544_ / 2 - 21, 30, 16).m_253136_();
        Button nextKitButton = Button.m_253074_((Component)Component.m_237113_((String)" > "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.f_96541_.f_91074_, true)).m_252987_(this.f_96543_ / 2 + 47, this.f_96544_ / 2 - 21, 30, 16).m_253136_();
        Button chooseKitButton = Button.m_253074_((Component)Component.m_237113_((String)"Choose Starter Kit"), button -> {
            StarterClientFunctions.clearPriorEquipmentCache();
            Dispatcher.sendToServer((Object)new ToServerSendKitChoicePacket(VariablesClient.cachedStarterKitName));
            ConstantsClient.mc.m_91152_(null);
        }).m_252987_(this.f_96543_ / 2 - 60, this.f_96544_ / 2 + 88, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)previousKitButton);
        this.m_142416_((GuiEventListener)nextKitButton);
        this.m_142416_((GuiEventListener)chooseKitButton);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String playerName = "";
        if (this.f_96541_.f_91074_ != null) {
            playerName = this.f_96541_.f_91074_.m_7755_().getString();
        }
        String headerString = ConfigHandler.chooseKitText.replace("%s", playerName);
        if (playerName.equals("")) {
            headerString = headerString.replace(", p", "P");
        }
        MutableComponent headerComponent = Component.m_237113_((String)headerString).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
        int headerWidth = this.f_96547_.m_92852_((FormattedText)headerComponent);
        guiGraphics.m_280614_(this.f_96547_, (Component)headerComponent, -((headerWidth - this.imageWidth) / 2), -16, 0, true);
        String fullKitName = Util.formatKitName(VariablesClient.cachedStarterKitName);
        Object kitName = fullKitName;
        while (this.f_96547_.m_92895_((String)kitName) > 88) {
            kitName = Util.removeLastChar((String)kitName);
        }
        if (!fullKitName.equalsIgnoreCase((String)kitName)) {
            kitName = (String)kitName + "...";
        }
        guiGraphics.m_280056_(this.f_96547_, (String)kitName, 79, 7, 0x404040, false);
        if (VariablesClient.cachedStarterKitDescriptions.containsKey(VariablesClient.cachedStarterKitName)) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            String kitDescription = VariablesClient.cachedStarterKitDescriptions.get(VariablesClient.cachedStarterKitName);
            MutableComponent descriptionComponent = Component.m_237113_((String)kitDescription);
            poseStack.m_85841_(0.66f, 0.66f, 0.66f);
            int y = 28;
            List descriptionLines = ComponentRenderUtils.m_94005_((FormattedText)descriptionComponent, (int)136, (Font)this.f_96541_.f_91062_);
            for (FormattedCharSequence line : descriptionLines) {
                int x = 120;
                if (y > 28) {
                    x -= 2;
                }
                if (y > 70 && descriptionLines.size() > 6) {
                    guiGraphics.m_280056_(this.f_96547_, "...", x + 132, y, 0x404040, false);
                }
                guiGraphics.m_280649_(this.f_96547_, line, x, y, 0x404040, false);
                if ((y += 10) <= 80) continue;
                break;
            }
            poseStack.m_85849_();
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.m_280218_(INVENTORY_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        StarterKitInventoryScreen.renderEntityInInventoryFollowsMouse(guiGraphics, i + 26, j + 8, i + 75, j + 78, 30, 0.0625f, this.xMouse, this.yMouse, (LivingEntity)this.f_96541_.f_91074_);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)(x1 + x2) / 2.0f;
        float g = (float)(y1 + y2) / 2.0f;
        guiGraphics.m_280588_(x1, y1, x2, y2);
        float h = (float)Math.atan((f - mouseX) / 40.0f);
        float i = (float)Math.atan((g - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.f_20883_;
        float k = entity.m_146908_();
        float l = entity.m_146909_();
        float m = entity.f_20886_;
        float n = entity.f_20885_;
        entity.f_20883_ = 180.0f + h * 20.0f;
        entity.m_146922_(180.0f + h * 40.0f);
        entity.m_146926_(-i * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Vector3f vector3f = new Vector3f(0.0f, entity.m_20206_() / 2.0f + yOffset, 0.0f);
        StarterKitInventoryScreen.renderEntityInInventory(guiGraphics, f, g, scale, vector3f, quaternionf, quaternionf2, entity);
        entity.f_20883_ = j;
        entity.m_146922_(k);
        entity.m_146926_(l);
        entity.f_20886_ = m;
        entity.f_20885_ = n;
        guiGraphics.m_280618_();
    }

    public static void renderEntityInInventory(GuiGraphics guiGraphics, float x, float y, int scale, Vector3f translate, Quaternionf pose, @Nullable Quaternionf cameraOrientation, LivingEntity entity) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)x, (double)y, 50.0);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        guiGraphics.m_280168_().m_252880_(translate.x, translate.y, translate.z);
        guiGraphics.m_280168_().m_252781_(pose);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityRenderDispatcher.m_252923_(cameraOrientation);
        }
        entityRenderDispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0));
        guiGraphics.m_280262_();
        entityRenderDispatcher.m_114468_(true);
        guiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    @Override
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return !this.widthTooNarrow && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return !this.widthTooNarrow && super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected void slotClicked(@NotNull Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
    }

    public void recipesUpdated() {
    }
}

