/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.inventory;

import com.mojang.datafixers.util.Pair;
import com.natamus.starterkit_common_forge.data.VariablesClient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class StarterKitInventoryMenu
extends RecipeBookMenu<CraftingContainer> {
    public static final int CONTAINER_ID = 0;
    public static final int RESULT_SLOT = 0;
    public static final int CRAFT_SLOT_START = 0;
    public static final int CRAFT_SLOT_END = 0;
    public static final int ARMOR_SLOT_START = 5;
    public static final int ARMOR_SLOT_END = 9;
    public static final int INV_SLOT_START = 9;
    public static final int INV_SLOT_END = 36;
    public static final int USE_ROW_SLOT_START = 36;
    public static final int USE_ROW_SLOT_END = 45;
    public static final int SHIELD_SLOT = 45;
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final boolean active;
    private final Player owner;

    public StarterKitInventoryMenu(Player player) {
        super(null, 0);
        int i;
        this.active = true;
        this.owner = player;
        if (VariablesClient.cachedStarterKitInventory == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentSlot = SLOT_IDS[i];
            this.m_38897_(new Slot((Container)VariablesClient.cachedStarterKitInventory, 39 - i, 8, 8 + i * 18){

                public void m_269206_(@NotNull ItemStack newStack, @NotNull ItemStack oldStack) {
                    StarterKitInventoryMenu.onEquipItem(StarterKitInventoryMenu.this.owner, equipmentSlot, newStack, oldStack);
                    super.m_269206_(newStack, oldStack);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(@NotNull Player player) {
                    ItemStack itemStack = this.m_7993_();
                    return false;
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlot.m_20749_()]);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)VariablesClient.cachedStarterKitInventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)VariablesClient.cachedStarterKitInventory, i, 8 + i * 18, 142));
        }
        this.m_38897_(new Slot((Container)VariablesClient.cachedStarterKitInventory, 40, 77, 62){

            public void m_269206_(@NotNull ItemStack newStack, @NotNull ItemStack oldStack) {
                StarterKitInventoryMenu.onEquipItem(StarterKitInventoryMenu.this.owner, EquipmentSlot.OFFHAND, newStack, oldStack);
                super.m_269206_(newStack, oldStack);
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
    }

    static void onEquipItem(Player player, EquipmentSlot slot, ItemStack newItem, ItemStack oldItem) {
        player.m_238392_(slot, oldItem, newItem);
    }

    public static boolean isHotbarSlot(int index) {
        return index >= 36 && index < 45 || index == 45;
    }

    public void m_5816_(@NotNull StackedContents itemHelper) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(@NotNull RecipeHolder<? extends Recipe<CraftingContainer>> recipe) {
        return false;
    }

    public void m_6199_(@NotNull Container container) {
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_5882_(@NotNull ItemStack stack, @NotNull Slot slot) {
        return false;
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 0;
    }

    public int m_6656_() {
        return 0;
    }

    public int m_6653_() {
        return 5;
    }

    public CraftingContainer getCraftSlots() {
        return null;
    }

    @NotNull
    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int slotIndex) {
        return slotIndex != this.m_6636_();
    }
}

