/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.functions;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.GearFunctions;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_forge.config.ConfigHandler;
import com.natamus.starterkit_common_forge.data.Constants;
import com.natamus.starterkit_common_forge.data.Variables;
import com.natamus.starterkit_common_forge.functions.StarterCheckFunctions;
import com.natamus.starterkit_common_forge.functions.StarterDefaultKitFunctions;
import com.natamus.starterkit_common_forge.networking.packets.ToClientAskIfModIsInstalledPacket;
import com.natamus.starterkit_common_forge.networking.packets.ToClientSelectFirstSlotPacket;
import com.natamus.starterkit_common_forge.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class StarterGearFunctions {
    public static void initStarterKitHandle(Level level, Player player, @Nullable Player commandPlayer) {
        StarterGearFunctions.initStarterKitHandle(level, player, commandPlayer, "");
    }

    public static void initStarterKitHandle(Level level, Player player, @Nullable Player commandPlayer, String kitName) {
        UUID uuid = player.m_20148_();
        TaskFunctions.enqueueCollectiveTask((MinecraftServer)level.m_7654_(), () -> {
            if (StarterCheckFunctions.shouldPlayerReceiveStarterKit(level, player) || commandPlayer != null) {
                if (ConfigHandler.usePotionEffectsInStarterKit) {
                    player.m_21219_();
                }
                if (!ConfigHandler.randomizeMultipleKitsToggle && Variables.starterGearEntries.size() > 1 && kitName.equals("")) {
                    Dispatcher.sendToClient((Object)new ToClientAskIfModIsInstalledPacket(), (ServerPlayer)((ServerPlayer)player));
                    TaskFunctions.enqueueCollectiveTask((MinecraftServer)level.m_7654_(), () -> {
                        if (!Variables.playersWithModInstalledOnClient.contains(uuid)) {
                            StarterGearFunctions.chooseOrGiveStarterKit(player, commandPlayer, kitName);
                        }
                    }, (int)100);
                } else {
                    StarterGearFunctions.giveStarterKit(player, commandPlayer, kitName);
                }
            }
        }, (int)10);
    }

    public static void chooseOrGiveStarterKit(Player player, @Nullable Player commandPlayer, String kitName) {
        int kitCount = Variables.starterGearEntries.size();
        if (kitCount == 0) {
            return;
        }
        if (!ConfigHandler.randomizeMultipleKitsToggle && kitCount > 1 && kitName.equals("")) {
            StarterGearFunctions.chooseStarterKitViaCommands(player);
            return;
        }
        StarterGearFunctions.giveStarterKit(player, commandPlayer, kitName);
    }

    public static void chooseStarterKitViaCommands(Player player) {
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.m_237113_((String)ConfigHandler.chooseKitText.replace("%s", player.m_7755_().getString())).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD), (boolean)true);
        MessageFunctions.sendMessage((Player)player, (String)"  /sk choose <kit_name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((Player)player, (String)"  /sk info <kit_name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((Player)player, (String)(" Available kits: " + StringUtils.join(StarterGearFunctions.getActiveKitNames(), (String)", ")), (ChatFormatting)ChatFormatting.GRAY, (boolean)true);
    }

    public static String giveStarterKit(Player player, @Nullable Player commandPlayer) {
        return StarterGearFunctions.giveStarterKit(player, commandPlayer, "");
    }

    public static String giveStarterKit(Player player, @Nullable Player commandPlayer, String kitName) {
        if (Variables.starterGearEntries.isEmpty()) {
            return null;
        }
        if (!Variables.starterGearEntries.containsKey(kitName)) {
            kitName = "";
        }
        String kitGearString = "";
        if (kitName.equals("")) {
            String[] allKitNames = Variables.starterGearEntries.keySet().toArray(new String[0]);
            String randomKitName = allKitNames[GlobalVariables.random.nextInt(allKitNames.length)];
            if (!Variables.starterGearEntries.containsKey(randomKitName)) {
                Constants.logger.warn("[Starter Kit] Unable to find a starter kit to give with the name '" + randomKitName + "'.");
                return null;
            }
            kitGearString = Variables.starterGearEntries.get(randomKitName);
            kitName = randomKitName;
        } else {
            kitGearString = Variables.starterGearEntries.get(kitName);
        }
        if (kitGearString.equals("")) {
            Constants.logger.warn("[Starter Kit] Unable to find a starter kit to give.");
            return null;
        }
        ArrayList<ItemStack> toAddAfter = new ArrayList<ItemStack>();
        if (ConfigHandler.addExistingItemsAfterKitSet) {
            Inventory inv = player.m_150109_();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                toAddAfter.add(itemStack.m_41777_());
            }
        }
        GearFunctions.setPlayerGearFromGearString((Player)player, (String)kitGearString, (boolean)ConfigHandler.usePotionEffectsInStarterKit);
        if (toAddAfter.size() > 0) {
            for (ItemStack itemStackToAdd : toAddAfter) {
                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)itemStackToAdd);
            }
        }
        if (commandPlayer != null) {
            MessageFunctions.sendMessage((Player)commandPlayer, (String)(player.m_7755_().getString() + " has been given the '" + Util.formatKitName(kitName) + "' starter kit!"), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        }
        StarterCheckFunctions.addPlayerToTrackingMap(player);
        Dispatcher.sendToClient((Object)new ToClientSelectFirstSlotPacket(), (ServerPlayer)((ServerPlayer)player));
        return kitName;
    }

    public static String createStarterKitFile(Player player, String kitName, boolean adding) {
        String playerGearString = GearFunctions.getGearStringFromPlayer((Player)player, (boolean)ConfigHandler.usePotionEffectsInStarterKit);
        if (!adding) {
            StarterGearFunctions.moveAllKitsToInactive();
        }
        if (((String)kitName).equals("")) {
            File[] files = Util.configKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"));
            kitName = "Kit_" + (files.length + 1);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(Util.configKitPath + File.separator + (String)kitName + ".txt", StandardCharsets.UTF_8);
            writer.print(playerGearString);
        }
        catch (IOException ex) {
            Constants.logger.warn("[Starter Kit] Something went wrong while writing the new starter kit file.");
            ex.printStackTrace();
        }
        if (writer != null) {
            writer.close();
        }
        StarterGearFunctions.processKitFiles();
        return kitName;
    }

    public static boolean moveKitToInactive(String kitName) {
        String kitPath = Util.configKitPath + File.separator + kitName + ".txt";
        File kit = new File(kitPath);
        if (!kit.isFile()) {
            return false;
        }
        String destinationPath = Util.configInactiveKitDir.getAbsolutePath() + File.separator + kitName + ".txt";
        boolean movedCorrectly = StarterGearFunctions.moveKit(kitPath, destinationPath);
        StarterGearFunctions.processKitFiles();
        return movedCorrectly;
    }

    public static void moveAllKitsToInactive() {
        File[] files;
        for (File file : files = Util.configKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"))) {
            String filePath = Util.configKitDir.getAbsolutePath() + File.separator + file.getName();
            String destinationPath = Util.configInactiveKitDir.getAbsolutePath() + File.separator + file.getName();
            StarterGearFunctions.moveKit(filePath, destinationPath);
        }
        StarterGearFunctions.processKitFiles();
    }

    public static boolean moveKitToActive(String kitName) {
        String kitPath = Util.configInactiveKitPath + File.separator + kitName + ".txt";
        File kit = new File(kitPath);
        if (!kit.isFile()) {
            return false;
        }
        String destinationPath = Util.configKitDir.getAbsolutePath() + File.separator + kitName + ".txt";
        boolean movedCorrectly = StarterGearFunctions.moveKit(kitPath, destinationPath);
        StarterGearFunctions.processKitFiles();
        return movedCorrectly;
    }

    public static void moveAllKitsToActive() {
        File[] files;
        for (File file : files = Util.configInactiveKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"))) {
            String filePath = Util.configInactiveKitDir.getAbsolutePath() + File.separator + file.getName();
            String destinationPath = Util.configKitDir.getAbsolutePath() + File.separator + file.getName();
            StarterGearFunctions.moveKit(filePath, destinationPath);
        }
        StarterGearFunctions.processKitFiles();
    }

    private static boolean moveKit(String filePath, String destinationPath) {
        File destinationFile = new File(destinationPath);
        while (destinationFile.exists()) {
            destinationPath = destinationPath.replace(".txt", "_.txt");
            destinationFile = new File(destinationPath);
        }
        try {
            Files.move(Paths.get(filePath, new String[0]), Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static void processKitFiles() {
        Variables.starterGearEntries = new HashMap();
        try {
            File[] files = Util.configKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"));
            if (files.length == 0 && !new File(Util.configInactiveKitPath + File.separator + "Default.txt").isFile()) {
                StarterDefaultKitFunctions.createDefaultKits(false);
                files = Util.configKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"));
            }
            boolean renamedFiles = false;
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.contains(" ")) continue;
                Files.move(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(file.getAbsolutePath().replace(fileName, fileName.replace(" ", "_")), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                renamedFiles = true;
            }
            if (renamedFiles) {
                files = Util.configKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"));
            }
            for (File file : files) {
                String kitName = file.getName().replace(".txt", "");
                String gearString = Files.readString(Paths.get(file.getAbsolutePath(), new String[0]));
                Variables.starterGearEntries.put(kitName, gearString);
                File matchingKitDescriptionFile = new File(Util.configDescriptionPath + File.separator + kitName + ".txt");
                if (matchingKitDescriptionFile.isFile()) continue;
                PrintWriter descriptionWriter = new PrintWriter(Util.configDescriptionPath + File.separator + kitName + ".txt", StandardCharsets.UTF_8);
                descriptionWriter.print("You can edit this description in ./config/starterkit/description/" + kitName + ".txt!");
                descriptionWriter.close();
            }
            StarterGearFunctions.processKitDescriptionFiles();
        }
        catch (Exception ex) {
            Constants.logger.warn("[Starter Kit] Unable to process the starter kit files.");
            ex.printStackTrace();
        }
    }

    private static void processKitDescriptionFiles() throws IOException {
        File[] files;
        Variables.starterKitDescriptions = new HashMap();
        for (File file : files = Util.configDescriptionDir.listFiles(pathname -> pathname.getName().endsWith(".txt"))) {
            String kitName = file.getName().replace(".txt", "");
            String kitDescription = Files.readString(Paths.get(file.getAbsolutePath(), new String[0]));
            Variables.starterKitDescriptions.put(kitName, kitDescription);
        }
    }

    public static List<String> getActiveKitNames() {
        return StarterGearFunctions.getActiveKitNames(Variables.starterGearEntries, false);
    }

    public static List<String> getActiveKitNames(boolean includeAll) {
        return StarterGearFunctions.getActiveKitNames(Variables.starterGearEntries, includeAll);
    }

    public static List<String> getActiveKitNames(HashMap<String, String> entryMap) {
        return StarterGearFunctions.getActiveKitNames(entryMap, false);
    }

    public static List<String> getActiveKitNames(HashMap<String, String> entryMap, boolean includeAll) {
        ArrayList<String> kitNames = new ArrayList<String>(entryMap.keySet());
        if (includeAll) {
            kitNames.add("_all");
        }
        Collections.sort(kitNames);
        return kitNames;
    }

    public static List<String> getInactiveKitNames() {
        return StarterGearFunctions.getInactiveKitNames(false);
    }

    public static List<String> getInactiveKitNames(boolean includeAll) {
        File[] files;
        ArrayList<String> inactiveKitNames = new ArrayList<String>();
        for (File file : files = Util.configInactiveKitDir.listFiles(pathname -> pathname.getName().endsWith(".txt"))) {
            String inactiveKitName = file.getName().replace(".txt", "");
            inactiveKitNames.add(inactiveKitName);
        }
        if (includeAll) {
            inactiveKitNames.add("_all");
        }
        Collections.sort(inactiveKitNames);
        return inactiveKitNames;
    }

    public static int showKitInformation(Player player, String kitName) {
        String kitDescription = "";
        if (Variables.starterKitDescriptions.containsKey(kitName) && (kitDescription = Variables.starterKitDescriptions.get(kitName)).contains("/config/starterkit/description/")) {
            kitDescription = "N/A";
        }
        MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.m_237113_((String)"Name: ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)Util.formatKitName(kitName)).m_130940_(ChatFormatting.GRAY)), (boolean)true);
        MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.m_237113_((String)"Description: ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)kitDescription).m_130940_(ChatFormatting.GRAY)));
        StringBuilder kitItems = new StringBuilder();
        if (Variables.starterGearEntries.containsKey(kitName)) {
            List kitItemList = GearFunctions.getItemStackListFromGearString((String)Variables.starterGearEntries.get(kitName));
            for (ItemStack itemStack : kitItemList) {
                Object count;
                if (itemStack.m_41619_()) continue;
                if (!kitItems.toString().equals("")) {
                    kitItems.append(", ");
                }
                if (((String)(count = itemStack.m_41613_() + " ")).equals("1 ")) {
                    count = "";
                }
                kitItems.append((String)count).append(itemStack.m_41611_().getString().replace("[", "").replace("]", "").toLowerCase());
            }
        }
        MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.m_237113_((String)"Items: ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)kitItems.toString()).m_130940_(ChatFormatting.GRAY)));
        return 1;
    }
}

