/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.recipe.DisableableShapedRecipe;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.recipe.RecipeEnchantedGraveKey;
import ovh.corail.tombstone.recipe.RecipeFamiliarReceptacle;
import ovh.corail.tombstone.recipe.ShapedSerializer;
import ovh.corail.tombstone.recipe.ShapelessSerializer;

public final class ModSerializers {
    public static RecipeSerializer<DisableableShapelessRecipe> DISABLEABLE_SHAPELESS = (RecipeSerializer)Helper.unsafeNullCast();
    public static RecipeSerializer<DisableableShapedRecipe> DISABLEABLE_SHAPED = (RecipeSerializer)Helper.unsafeNullCast();
    public static RecipeSerializer<RecipeEnchantedGraveKey> ENCHANTED_GRAVE_KEY = (RecipeSerializer)Helper.unsafeNullCast();
    public static RecipeSerializer<RecipeFamiliarReceptacle> FAMILIAR_RECEPTACLE = (RecipeSerializer)Helper.unsafeNullCast();

    static void onRegister(RegisterEvent event) {
        DISABLEABLE_SHAPELESS = new ShapelessSerializer<DisableableShapelessRecipe>(DisableableShapelessRecipe::new);
        ModSerializers.register(event, DISABLEABLE_SHAPELESS, "disableable_shapeless");
        DISABLEABLE_SHAPED = new ShapedSerializer<DisableableShapedRecipe>(DisableableShapedRecipe::new);
        ModSerializers.register(event, DISABLEABLE_SHAPED, "disableable_shaped");
        ENCHANTED_GRAVE_KEY = new SimpleCraftingRecipeSerializer(RecipeEnchantedGraveKey::new);
        ModSerializers.register(event, ENCHANTED_GRAVE_KEY, "enchanted_grave_key");
        FAMILIAR_RECEPTACLE = new SimpleCraftingRecipeSerializer(RecipeFamiliarReceptacle::new);
        ModSerializers.register(event, FAMILIAR_RECEPTACLE, "familiar_receptacle");
    }

    private static void register(RegisterEvent event, RecipeSerializer<?> serializer, String name) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, new ResourceLocation("tombstone", name), () -> serializer);
    }
}

