/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import java.util.stream.IntStream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;

public final class RecipeFamiliarReceptacle
extends CustomRecipe {
    public RecipeFamiliarReceptacle(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        if (!ModItems.familiar_receptacle.isEnabled()) {
            return false;
        }
        block5: for (int slotId = 0; slotId < inv.m_6643_(); ++slotId) {
            ItemStack stack = inv.m_8020_(slotId);
            switch (slotId) {
                case 0: 
                case 2: 
                case 6: 
                case 8: {
                    if (stack.m_150930_(Items.f_42586_)) continue block5;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    if (stack.m_204117_(Tags.Items.INGOTS_IRON)) continue block5;
                    return false;
                }
                case 4: {
                    if (stack.m_150930_((Item)ModItems.impregnated_diamond)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack res = new ItemStack((ItemLike)ModItems.familiar_receptacle);
        String impregnatedType = IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)inv).m_8020_(arg_0)).filter(stack -> stack.m_150930_((Item)ModItems.impregnated_diamond)).findFirst().map(ModItems.impregnated_diamond::getEntityType).orElse("");
        if (!impregnatedType.isEmpty() && TamableType.isTamable(impregnatedType)) {
            ModItems.familiar_receptacle.setCapturableType(res, impregnatedType);
        }
        return res;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)ModItems.familiar_receptacle);
    }

    public boolean m_8004_(int width, int height) {
        return width > 2 && height > 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModSerializers.FAMILIAR_RECEPTACLE;
    }
}

