/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;
import ovh.corail.tombstone.registry.ModTags;

public final class RecipeEnchantedGraveKey
extends CustomRecipe {
    public RecipeEnchantedGraveKey(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        if (!ModItems.grave_key.isEnabled()) {
            return false;
        }
        boolean hasKey = false;
        boolean hasCompo = false;
        for (int slotId = 0; slotId < inv.m_6643_(); ++slotId) {
            ItemStack stack = inv.m_8020_(slotId);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.grave_key)) {
                if (hasKey || ModItems.grave_key.isEnchanted(stack)) {
                    return false;
                }
                hasKey = true;
                continue;
            }
            if (stack.m_204117_(ModTags.Items.enchanted_grave_key_ingredients)) {
                if (hasCompo) {
                    return false;
                }
                hasCompo = true;
                continue;
            }
            return false;
        }
        return hasKey && hasCompo;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack key = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_150930_((Item)ModItems.grave_key)) continue;
            if (!key.m_41619_() || ModItems.grave_key.isEnchanted(stack)) {
                return ItemStack.f_41583_;
            }
            key = stack;
        }
        return key.m_41619_() ? ItemStack.f_41583_ : this.GetEnchantedKey(key);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.GetEnchantedKey(new ItemStack((ItemLike)ModItems.grave_key));
    }

    private ItemStack GetEnchantedKey(ItemStack key) {
        return NBTStackHelper.setBoolean(key.m_41777_(), "enchant", true);
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    public boolean m_5598_() {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModSerializers.ENCHANTED_GRAVE_KEY;
    }
}

