/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import ovh.corail.tombstone.network.CMessageConfig;
import ovh.corail.tombstone.network.CMessageCooldown;
import ovh.corail.tombstone.network.CMessageEffect;
import ovh.corail.tombstone.network.CMessageFamiliar;
import ovh.corail.tombstone.network.CMessageKnowledgeScreen;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSmokeColumn;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.SMessagePlayerPreference;
import ovh.corail.tombstone.network.SMessageResetPerk;
import ovh.corail.tombstone.network.SMessageUpgradePerk;

public class PacketHandler {
    private static final int PROTOCOL_VERSION = Integer.parseInt("8.6.2".replace(".", ""));
    private static final SimpleChannel HANDLER = ChannelBuilder.named((String)"tombstone_channel").networkProtocolVersion(PROTOCOL_VERSION).acceptedVersions(PacketHandler.getVersionTest()).clientAcceptedVersions(PacketHandler.getVersionTest()).simpleChannel();

    @NotNull
    private static Channel.VersionTest getVersionTest() {
        return (status, version) -> status == Channel.VersionTest.Status.PRESENT && PROTOCOL_VERSION == version;
    }

    public static <T> void sendToServer(T message) {
        HANDLER.send(message, PacketDistributor.SERVER.noArg());
    }

    public static <T> void sendToPlayer(T message, ServerPlayer player) {
        HANDLER.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public static <T> void sendToAllTrackingPlayers(T message, LivingEntity entity) {
        HANDLER.send(message, PacketDistributor.TRACKING_ENTITY.with((Object)entity));
    }

    public static <T> void sendToAllTrackingPlayersAndSelf(T message, LivingEntity entity) {
        HANDLER.send(message, PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity));
    }

    public static <T> void sendToAllPlayers(T message) {
        HANDLER.send(message, PacketDistributor.ALL.noArg());
    }

    static {
        HANDLER.messageBuilder(SMessagePlayerPreference.class).encoder(SMessagePlayerPreference::toBytes).decoder(SMessagePlayerPreference::fromBytes).consumerNetworkThread(SMessagePlayerPreference.Handler::handle).add();
        HANDLER.messageBuilder(CMessageLogin.class).encoder(CMessageLogin::toBytes).decoder(CMessageLogin::fromBytes).consumerNetworkThread(CMessageLogin.Handler::handle).add();
        HANDLER.messageBuilder(CMessageTBCapability.class).encoder(CMessageTBCapability::toBytes).decoder(CMessageTBCapability::fromBytes).consumerNetworkThread(CMessageTBCapability.Handler::handle).add();
        HANDLER.messageBuilder(SMessageUpgradePerk.class).encoder(SMessageUpgradePerk::toBytes).decoder(SMessageUpgradePerk::fromBytes).consumerNetworkThread(SMessageUpgradePerk.Handler::handle).add();
        HANDLER.messageBuilder(CMessageSmokeColumn.class).encoder(CMessageSmokeColumn::toBytes).decoder(CMessageSmokeColumn::fromBytes).consumerNetworkThread(CMessageSmokeColumn.Handler::handle).add();
        HANDLER.messageBuilder(CMessageConfig.class).encoder(CMessageConfig::toBytes).decoder(CMessageConfig::fromBytes).consumerNetworkThread(CMessageConfig.Handler::handle).add();
        HANDLER.messageBuilder(CMessageCooldown.class).encoder(CMessageCooldown::toBytes).decoder(CMessageCooldown::fromBytes).consumerNetworkThread(CMessageCooldown.Handler::handle).add();
        HANDLER.messageBuilder(CMessageEffect.class).encoder(CMessageEffect::toBytes).decoder(CMessageEffect::fromBytes).consumerNetworkThread(CMessageEffect.Handler::handle).add();
        HANDLER.messageBuilder(CMessagePrayer.class).encoder(CMessagePrayer::toBytes).decoder(CMessagePrayer::fromBytes).consumerNetworkThread(CMessagePrayer.Handler::handle).add();
        HANDLER.messageBuilder(CMessageProtection.class).encoder(CMessageProtection::toBytes).decoder(CMessageProtection::fromBytes).consumerNetworkThread(CMessageProtection.Handler::handle).add();
        HANDLER.messageBuilder(SMessageResetPerk.class).encoder(SMessageResetPerk::toBytes).decoder(SMessageResetPerk::fromBytes).consumerNetworkThread(SMessageResetPerk.Handler::handle).add();
        HANDLER.messageBuilder(CMessageKnowledgeScreen.class).encoder(CMessageKnowledgeScreen::toBytes).decoder(CMessageKnowledgeScreen::fromBytes).consumerNetworkThread(CMessageKnowledgeScreen.Handler::handle).add();
        HANDLER.messageBuilder(CMessageSpellCasting.class).encoder(CMessageSpellCasting::toBytes).decoder(CMessageSpellCasting::fromBytes).consumerNetworkThread(CMessageSpellCasting.Handler::handle).add();
        HANDLER.messageBuilder(CMessageServant.class).encoder(CMessageServant::toBytes).decoder(CMessageServant::fromBytes).consumerNetworkThread(CMessageServant.Handler::handle).add();
        HANDLER.messageBuilder(CMessageLevelUp.class).encoder(CMessageLevelUp::toBytes).decoder(CMessageLevelUp::fromBytes).consumerNetworkThread(CMessageLevelUp.Handler::handle).add();
        HANDLER.messageBuilder(CMessageFamiliar.class).encoder(CMessageFamiliar::toBytes).decoder(CMessageFamiliar::fromBytes).consumerNetworkThread(CMessageFamiliar.Handler::handle).add();
    }
}

