/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.helper.Helper;

public record CMessageSpellCasting(int entityId, int color) {
    static CMessageSpellCasting fromBytes(FriendlyByteBuf buf) {
        return new CMessageSpellCasting(buf.m_130242_(), buf.readInt());
    }

    static void toBytes(CMessageSpellCasting msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.writeInt(msg.color);
    }

    public static class Handler {
        static void handle(final CMessageSpellCasting msg, CustomPayloadEvent.Context ctx) {
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg2.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(caster -> caster.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(c -> {
                            c.setCastingColor(msg2.color);
                            if (c.isCasting()) {
                                ModTombstone.PROXY.produceParticleCasting(1.0, msg2.color, (LivingEntity)caster, e -> !c.isCasting());
                            }
                        }));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

