/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.helper.Helper;

public record CMessageServant(int entityId, UUID uuid, boolean isServant) {
    static CMessageServant fromBytes(FriendlyByteBuf buf) {
        return new CMessageServant(buf.m_130242_(), buf.m_130259_(), buf.readBoolean());
    }

    static void toBytes(CMessageServant msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130077_(msg.uuid);
        buf.writeBoolean(msg.isServant);
    }

    public static class Handler {
        static void handle(final CMessageServant msg, CustomPayloadEvent.Context ctx) {
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg2.entityId)).ifPresent(entity -> {
                            if (msg2.isServant) {
                                entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> cap.setOwnerId(msg2.uuid));
                            } else {
                                entity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).ifPresent(cap -> cap.setOwnerId(msg2.uuid));
                            }
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

