/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CustomContainer;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemBook {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
        this.withDefaultInfo();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        CompoundTag searchTag;
        ItemStack mainhand;
        if (stack.m_41720_() != this || (mainhand = player.m_21205_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List<String>)((List)ConfigTombstone.magic_item.deniedItemToRecycle.get()), RegistryHelper.getRegistryName(mainhand.m_41720_()))) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (mainhand.m_41768_() && !((Boolean)ConfigTombstone.magic_item.canRecycleDamagedItem.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (mainhand.m_41783_() != null && mainhand.m_41783_().m_128425_("Items", 9) || mainhand.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        Item searchItem = mainhand.m_41720_();
        if (mainhand.m_41783_() == null) {
            searchTag = null;
        } else {
            CompoundTag tag = mainhand.m_41783_().m_6426_();
            if (tag.m_128441_("Damage")) {
                tag.m_128405_("Damage", 0);
            }
            tag.m_128473_("RepairCost");
            tag.m_128473_("Enchantments");
            searchTag = tag.m_128456_() ? null : tag;
        }
        NonNullList ingredients = NonNullList.m_122779_();
        ItemStack recipeResult = this.checkAdditionalRecipes(searchItem, (List<ItemStack>)ingredients);
        if (recipeResult.m_41619_()) {
            CraftingRecipe recipe = Objects.requireNonNull(player.m_20194_()).m_129894_().m_44013_(RecipeType.f_44107_).stream().map(RecipeHolder::f_291008_).filter(r -> this.compareRecipeResult(searchItem, searchTag, r.m_8043_(level.m_9598_()))).max(Comparator.comparingLong(r -> r.m_7527_().stream().filter(i -> !i.m_43947_()).count())).orElse(null);
            if (recipe == null) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
            if (recipe.m_8043_(level.m_9598_()).m_41613_() > mainhand.m_41613_()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
            }
            int count = recipe.m_7527_().size();
            NonNullList grid = NonNullList.m_122780_((int)count, (Object)ItemStack.f_41583_);
            for (int slotId2 = 0; slotId2 < count; ++slotId2) {
                ItemStack[] items;
                ItemStack result;
                Ingredient ing = (Ingredient)recipe.m_7527_().get(slotId2);
                if (ing.m_43947_() || (result = (items = ing.m_43908_())[Helper.RANDOM.nextInt(items.length)]).m_41619_()) continue;
                grid.set(slotId2, (Object)result.m_41777_());
            }
            NonNullList remains = recipe.m_7457_((Container)new CustomContainer((NonNullList<ItemStack>)grid));
            IntStream.range(0, grid.size()).filter(slotId -> ((ItemStack)remains.get(slotId)).m_41619_()).mapToObj(arg_0 -> ((NonNullList)grid).get(arg_0)).filter(i -> !i.m_41619_()).forEach(((List)ingredients)::add);
            recipeResult = recipe.m_8043_(level.m_9598_());
        }
        if (ingredients.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        int maxRecycle = mainhand.m_41613_() / recipeResult.m_41613_();
        stack.m_41774_(1);
        mainhand.m_41774_(recipeResult.m_41613_() * maxRecycle);
        for (ItemStack ingredient : ingredients) {
            int count = ingredient.m_41613_() * maxRecycle;
            int maxSize = ingredient.m_41741_();
            int fullStacks = count / maxSize;
            for (int i2 = 0; i2 < fullStacks; ++i2) {
                ItemStack newStack = ingredient.m_41777_();
                newStack.m_41764_(maxSize);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = ingredient.m_41777_();
            leftStack.m_41764_(left);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftStack);
        }
        ModTriggers.use_recycling.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }

    private boolean compareRecipeResult(Item searchItem, @Nullable CompoundTag searchTag, ItemStack lookup) {
        return lookup.m_150930_(searchItem) && (lookup.m_41783_() == null || searchTag != null && searchTag.equals((Object)lookup.m_41783_()));
    }

    private ItemStack checkAdditionalRecipes(Item searchItem, List<ItemStack> ingredients) {
        if (searchItem == Items.f_42654_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42454_, 7));
            return new ItemStack((ItemLike)Items.f_42654_);
        }
        if (searchItem == Items.f_42651_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42416_, 7));
            return new ItemStack((ItemLike)Items.f_42651_);
        }
        if (searchItem == Items.f_42652_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42417_, 7));
            return new ItemStack((ItemLike)Items.f_42652_);
        }
        if (searchItem == Items.f_42653_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 7));
            return new ItemStack((ItemLike)Items.f_42653_);
        }
        if (searchItem == Items.f_42396_ || searchItem == Items.f_42395_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 3));
            ingredients.add(new ItemStack((ItemLike)Items.f_42398_, 2));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)searchItem);
        }
        if (searchItem == Items.f_42393_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 2));
            ingredients.add(new ItemStack((ItemLike)Items.f_42398_));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42393_);
        }
        if (searchItem == Items.f_42397_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 2));
            ingredients.add(new ItemStack((ItemLike)Items.f_42398_, 2));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42397_);
        }
        if (searchItem == Items.f_42394_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_));
            ingredients.add(new ItemStack((ItemLike)Items.f_42398_, 2));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42394_);
        }
        if (searchItem == Items.f_42483_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 4));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42483_);
        }
        if (searchItem == Items.f_42480_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 5));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42480_);
        }
        if (searchItem == Items.f_42481_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 8));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42481_);
        }
        if (searchItem == Items.f_42482_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 7));
            ingredients.add(new ItemStack((ItemLike)Items.f_42418_));
            return new ItemStack((ItemLike)Items.f_42482_);
        }
        return ItemStack.f_41583_;
    }
}

