/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.RegistryHelper;

public enum TamableType {
    TAMABLE(e -> e instanceof TamableAnimal, (player, entity) -> ((TamableAnimal)entity).m_21828_(player), entity -> ((TamableAnimal)entity).m_21805_(), (entity, tag) -> {}),
    HORSE(e -> e instanceof AbstractHorse, (player, entity) -> ((AbstractHorse)entity).m_30637_(player), entity -> ((AbstractHorse)entity).m_21805_(), (entity, tag) -> {
        if (entity instanceof AbstractChestedHorse) {
            ((AbstractChestedHorse)entity).m_30504_(false);
        }
    }),
    FRIENDLY_ANIMAL(e -> e instanceof Fox, (player, entity) -> entity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).ifPresent(cap -> {
        UUID playerUUID = player.m_36316_().getId();
        ((Fox)entity).m_28515_(playerUUID);
        cap.setOwnerId(playerUUID);
        cap.setAI((PathfinderMob)entity);
    }), entity -> EntityHelper.getFriendlyOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.m_8061_(slot, ItemStack.f_41583_);
        }
    }),
    UNDEAD(PrayerHelper::isValidUndead, (player, entity) -> entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> {
        cap.setOwnerId(player.m_36316_().getId());
        cap.setAI((PathfinderMob)entity);
    }), entity -> EntityHelper.getServantOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.m_8061_(slot, ItemStack.f_41583_);
        }
    });

    final Predicate<Entity> predic;
    final BiConsumer<Player, Entity> tame;
    final Function<Entity, UUID> ownerId;
    final BiConsumer<Entity, CompoundTag> onCapture;
    static final Map<String, TamableType> TAMABLE_TYPE;
    static final Set<String> SUMMONABLE_TYPE;

    private TamableType(Predicate<Entity> predic, BiConsumer<Player, Entity> tame, Function<Entity, UUID> ownerId, BiConsumer<Entity, CompoundTag> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init(Level level) {
        if (!TAMABLE_TYPE.isEmpty() || !SUMMONABLE_TYPE.isEmpty()) {
            return;
        }
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            String registryName = ((ResourceKey)entry.getKey()).m_135782_().toString();
            try {
                Entity entity = ((EntityType)entry.getValue()).m_20615_(level);
                if (entity == null) continue;
                Arrays.stream(TamableType.values()).filter(t -> t.predic.test(entity)).findFirst().ifPresent(tamable -> TAMABLE_TYPE.put(registryName, (TamableType)((Object)tamable)));
                if (!((EntityType)entry.getValue()).m_20654_() || !(entity instanceof Mob)) continue;
                SUMMONABLE_TYPE.add(registryName);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setTamedBy(Player player, Entity entity) {
        Optional.ofNullable(TamableType.getType(entity)).ifPresent(t -> t.tame.accept(player, entity));
    }

    public static boolean isTamedBy(LivingEntity owner, Entity entity) {
        return Optional.ofNullable(TamableType.getType(entity)).map(t -> t.getOwnerId(entity)).map(id -> id.equals(owner.m_20148_())).orElse(false);
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(Entity entity, CompoundTag tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTamable(String entityTypeString) {
        return TamableType.getType(entityTypeString) != null;
    }

    @Nullable
    public static TamableType getType(@Nullable Entity entity) {
        return TamableType.getType(RegistryHelper.getRegistryString(entity));
    }

    @Nullable
    public static TamableType getType(String entityTypeString) {
        return TAMABLE_TYPE.get(entityTypeString);
    }

    public static String getRandomTamableEntityTypeString() {
        return Helper.getRandomInList(TAMABLE_TYPE.keySet().stream().filter(type -> !Helper.containRL((List<String>)((List)ConfigTombstone.loot.unhandledTamableEntities.get()), type)).collect(Collectors.toList())).orElse("minecraft:cat");
    }

    public static String getRandomSummonableEntityTypeString() {
        return Helper.getRandomInList(SUMMONABLE_TYPE).orElse("minecraft:cat");
    }

    static {
        TAMABLE_TYPE = new ConcurrentHashMap<String, TamableType>();
        SUMMONABLE_TYPE = ConcurrentHashMap.newKeySet();
    }
}

