/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.registry.ModDamages;

public enum DamageCategory implements StringRepresentable
{
    SUFFOCATION(d -> d.m_269533_(DamageTypeTags.f_268581_) || d.m_276093_(DamageTypes.f_268612_) || d.m_276093_(DamageTypes.f_268613_) || d.m_276093_(DamageTypes.f_268441_) || DamageCategory.contains(d.m_19385_().toLowerCase(Locale.US), "spore", "poison")),
    BURN(d -> d.m_269533_(DamageTypeTags.f_268745_)),
    LIGHTNING(d -> d.m_269533_(DamageTypeTags.f_268725_)),
    FALL(d -> d.m_269533_(DamageTypeTags.f_268549_) || d.m_276093_(DamageTypes.f_268576_)),
    COLD(d -> {
        if (d.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        String type = d.m_19385_().toLowerCase(Locale.US);
        return type.startsWith("ice") || DamageCategory.contains(type, "chill", "frost", "snow", "cold");
    }),
    DARKNESS(d -> d.m_276093_(DamageTypes.f_268493_) || DamageCategory.isBeyondTheGrave(d) || d.m_276093_(DamageTypes.f_268482_) || DamageCategory.contains(d.m_19385_().toLowerCase(Locale.US), "lich", "haunt", "darkness", "spectr")),
    LIGHT(d -> false),
    UNKNOWN(d -> false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final Predicate<DamageSource> is;

    private DamageCategory(Predicate<DamageSource> predic) {
        this.is = predic;
    }

    public static boolean isProjectile(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_269533_(DamageTypeTags.f_268524_);
    }

    public static boolean isExplosion(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_269533_(DamageTypeTags.f_268415_);
    }

    public static boolean isThorn(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_276093_(DamageTypes.f_268440_);
    }

    public static boolean isBeyondTheGrave(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.m_276093_(ModDamages.getBTGKey());
    }

    public boolean is(DamageSource s) {
        return this.is.test(s);
    }

    public static DamageCategory of(DamageSource s) {
        for (DamageCategory damageCategory : DamageCategory.values()) {
            if (!damageCategory.is(s)) continue;
            return damageCategory;
        }
        return UNKNOWN;
    }

    private static boolean contains(String type, String ... containWords) {
        return Arrays.stream(containWords).anyMatch(type::contains);
    }

    public String m_7912_() {
        return this.name;
    }
}

