/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.ColorOptionSlider;
import ovh.corail.tombstone.gui.ColorSliderHandler;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.CustomOptionsRowList;
import ovh.corail.tombstone.gui.CycleConfigOption;
import ovh.corail.tombstone.gui.IOption;
import ovh.corail.tombstone.gui.ProgressOption;
import ovh.corail.tombstone.gui.SliderButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenConfig
extends TBScreen {
    private static final ResourceLocation tablet = new ResourceLocation("tombstone", "textures/item/grave_plate.png");
    private TabConfig tab = TabConfig.GRAVE;
    private final String nameToDisplay;
    private final PlayerPreference playerPreference = PlayerPreference.fromClientConfig();
    private boolean enhanced_tooltips;
    private boolean skipRespawnScreen;
    private boolean dateInMCTime;
    private boolean showInfoOnEnchantment;
    private boolean highlightGrave;
    private boolean showShieldParticle;
    private boolean allowHalloweenGhost;
    private boolean showMagicCircle;
    private boolean showTooltipCombine;
    private boolean noBlinkingNightvision;
    private CustomOptionsRowList deathList;
    private CustomOptionsRowList equipmentList;
    private CustomOptionsRowList miscList;
    private CustomOptionsRowList effectList;
    private ConfigTombstone.Client.GraveSkinRule graveSkinRule;
    private ConfigTombstone.Client.FogDensity fogDensity;
    private ConfigTombstone.Client.FogPeriod fogPeriod;
    private ConfigTombstone.Client.MarkerType markerType;
    private ConfigTombstone.Client.FontRule fontRule;
    private final ColorSliderHandler colorSliderHandler0;
    private final ColorSliderHandler colorSliderHandler1;
    private final ColorSliderHandler colorSliderHandler2;
    private final ColorSliderHandler colorSliderHandler3;
    private final ColorSliderHandler colorSliderHandler4;
    private boolean saveButtonHighlight;
    private boolean isDirty;
    private final IOption[] deathOptions;
    private final IOption[] equipmentOptions;
    private final IOption[] miscOptions;
    private final IOption[] effectOptions;
    private final List<Predicate<Boolean>> config_changed_predics;

    public ScreenConfig() {
        super((Component)LangKey.MESSAGE_CONFIG.getText(new Object[0]));
        this.enhanced_tooltips = (Boolean)ConfigTombstone.client.showEnhancedTooltips.get();
        this.skipRespawnScreen = (Boolean)ConfigTombstone.client.skipRespawnScreen.get();
        this.dateInMCTime = (Boolean)ConfigTombstone.client.dateInMCTime.get();
        this.showInfoOnEnchantment = (Boolean)ConfigTombstone.client.showInfoOnEnchantment.get();
        this.highlightGrave = (Boolean)ConfigTombstone.client.highlight.get();
        this.showShieldParticle = (Boolean)ConfigTombstone.client.showShieldParticle.get();
        this.allowHalloweenGhost = (Boolean)ConfigTombstone.client.allowHalloweenGhost.get();
        this.showMagicCircle = (Boolean)ConfigTombstone.client.showMagicCircle.get();
        this.showTooltipCombine = (Boolean)ConfigTombstone.client.showTooltipCombine.get();
        this.noBlinkingNightvision = (Boolean)ConfigTombstone.client.noBlinkingNightvision.get();
        this.graveSkinRule = (ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get());
        this.fogDensity = (ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get());
        this.fogPeriod = (ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get();
        this.markerType = (ConfigTombstone.Client.MarkerType)((Object)ConfigTombstone.client.markerType.get());
        this.fontRule = (ConfigTombstone.Client.FontRule)((Object)ConfigTombstone.client.fontRule.get());
        this.colorSliderHandler0 = new ColorSliderHandler("particle_casting_color", (Integer)ConfigTombstone.client.particleCastingColor.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler1 = new ColorSliderHandler("text_color_rip", (Integer)ConfigTombstone.client.textColorRIP.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler2 = new ColorSliderHandler("text_color_owner", (Integer)ConfigTombstone.client.textColorOwner.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler3 = new ColorSliderHandler("text_color_death_date", (Integer)ConfigTombstone.client.textColorDeathDate.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler4 = new ColorSliderHandler("fog_color", (Integer)ConfigTombstone.client.fogColor.get(), d -> {
            this.isDirty = d;
        });
        this.isDirty = true;
        IOption[] iOptionArray = new IOption[4];
        iOptionArray[0] = CycleConfigOption.create("grave_spawn_rule", ConfigTombstone.Client.GraveSpawnRule.values(), t -> Component.m_237115_((String)t.getTranslation()), this.playerPreference::getGraveSpawnRule, this.playerPreference::setGraveSpawnRule, d -> {
            this.isDirty = d;
        });
        iOptionArray[1] = CycleConfigOption.createOnOff("allow_grave_in_water", this.playerPreference::allowGraveInWater, this.playerPreference::setAllowGraveInWater, d -> {
            this.isDirty = d;
        });
        iOptionArray[2] = CycleConfigOption.createOnOff("skip_respawn_screen", () -> this.skipRespawnScreen, d -> {
            this.skipRespawnScreen = d;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray[3] = CycleConfigOption.createOnOff("activate_grave_by_sneaking", this.playerPreference::activateGraveBySneaking, this.playerPreference::setActivateGraveBySneaking, d -> {
            this.isDirty = d;
        });
        this.deathOptions = iOptionArray;
        IOption[] iOptionArray2 = new IOption[4];
        iOptionArray2[0] = CycleConfigOption.create("auto_equip_rule", ConfigTombstone.Client.AutoEquipRule.values(), t -> Component.m_237115_((String)t.getTranslation()), this.playerPreference::getAutoEquipRule, this.playerPreference::setAutoEquipRule, d -> {
            this.isDirty = d;
        });
        iOptionArray2[1] = CycleConfigOption.createOnOff("equip_elytra_in_priority", this.playerPreference::equipElytraInPriority, this.playerPreference::setEquipElytraInPriority, d -> {
            this.isDirty = d;
        });
        iOptionArray2[2] = CycleConfigOption.createOnOff("equip_curio_slot_magic_book", this.playerPreference::equipCurioSlotMagicBook, this.playerPreference::setEquipCurioSlotMagicBook, d -> {
            this.isDirty = d;
        });
        iOptionArray2[3] = CycleConfigOption.createOnOff("priorize_tool_on_hotbar", this.playerPreference::priorizeToolOnHotbar, this.playerPreference::setPriorizeToolOnHotbar, d -> {
            this.isDirty = d;
        });
        this.equipmentOptions = iOptionArray2;
        IOption[] iOptionArray3 = new IOption[9];
        iOptionArray3[0] = CycleConfigOption.createOnOff("show_enhanced_tooltips", () -> this.enhanced_tooltips, d -> {
            this.enhanced_tooltips = d;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[1] = CycleConfigOption.createOnOff("date_in_mc_time", () -> this.dateInMCTime, d -> {
            this.dateInMCTime = d;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[2] = CycleConfigOption.createOnOff("display_knowledge_message", this.playerPreference::displayKnowledgeMessage, this.playerPreference::setDisplayKnowledgeMessage, d -> {
            this.isDirty = d;
        });
        iOptionArray3[3] = CycleConfigOption.createOnOff("show_info_on_enchantment", () -> this.showInfoOnEnchantment, b -> {
            this.showInfoOnEnchantment = b;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[4] = CycleConfigOption.create("grave_skin_rule", ConfigTombstone.Client.GraveSkinRule.values(), t -> Component.m_237115_((String)t.getTranslation()), () -> this.graveSkinRule, b -> {
            this.graveSkinRule = b;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[5] = CycleConfigOption.create("fog_density", ConfigTombstone.Client.FogDensity.values(), t -> Component.m_237115_((String)t.getTranslation()), () -> this.fogDensity, b -> {
            this.fogDensity = b;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[6] = CycleConfigOption.create("fog_period", ConfigTombstone.Client.FogPeriod.values(), t -> Component.m_237115_((String)t.getTranslation()), () -> this.fogPeriod, b -> {
            this.fogPeriod = b;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[7] = CycleConfigOption.createOnOff("show_tooltip_combine", () -> this.showTooltipCombine, b -> {
            this.showTooltipCombine = b;
        }, d -> {
            this.isDirty = d;
        });
        iOptionArray3[8] = CycleConfigOption.create("font_rule", ConfigTombstone.Client.FontRule.values(), t -> Component.m_237115_((String)t.getTranslation()), () -> this.fontRule, b -> {
            this.fontRule = b;
        }, d -> {
            this.isDirty = d;
        });
        this.miscOptions = iOptionArray3;
        this.effectOptions = new IOption[]{CycleConfigOption.createOnOff("highlight", () -> this.highlightGrave, b -> {
            this.highlightGrave = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.create("marker_type", ConfigTombstone.Client.MarkerType.values(), t -> Component.m_237115_((String)t.getTranslation()), () -> this.markerType, b -> {
            this.markerType = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("show_shield_particle", () -> this.showShieldParticle, b -> {
            this.showShieldParticle = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("allow_halloween_ghost", () -> this.allowHalloweenGhost, b -> {
            this.allowHalloweenGhost = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("show_magic_circle", () -> this.showMagicCircle, b -> {
            this.showMagicCircle = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("no_blinking_nightvision", () -> this.noBlinkingNightvision, b -> {
            this.noBlinkingNightvision = b;
        }, d -> {
            this.isDirty = d;
        })};
        this.config_changed_predics = new ArrayList<Predicate<Boolean>>(){
            {
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.textColorRIP, ScreenConfig.this.colorSliderHandler1.getColor(), (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.textColorOwner, ScreenConfig.this.colorSliderHandler2.getColor(), (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.textColorDeathDate, ScreenConfig.this.colorSliderHandler3.getColor(), (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.showEnhancedTooltips, ScreenConfig.this.enhanced_tooltips, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.highlight, ScreenConfig.this.highlightGrave, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.skipRespawnScreen, ScreenConfig.this.skipRespawnScreen, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.showShieldParticle, ScreenConfig.this.showShieldParticle, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.allowHalloweenGhost, ScreenConfig.this.allowHalloweenGhost, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.dateInMCTime, ScreenConfig.this.dateInMCTime, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.showInfoOnEnchantment, ScreenConfig.this.showInfoOnEnchantment, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.graveSkinRule, ScreenConfig.this.graveSkinRule, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.fogDensity, ScreenConfig.this.fogDensity, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.fogPeriod, ScreenConfig.this.fogPeriod, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.showMagicCircle, ScreenConfig.this.showMagicCircle, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.markerType, ScreenConfig.this.markerType, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.fontRule, ScreenConfig.this.fontRule, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.particleCastingColor, ScreenConfig.this.colorSliderHandler0.getColor(), (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.fogColor, ScreenConfig.this.colorSliderHandler4.getColor(), (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.showTooltipCombine, ScreenConfig.this.showTooltipCombine, (boolean)u));
                this.add(u -> ScreenConfig.this.checkConfig(ConfigTombstone.client.noBlinkingNightvision, ScreenConfig.this.noBlinkingNightvision, (boolean)u));
            }
        };
        this.nameToDisplay = Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(p -> p.m_7755_().getString()).orElse("Unknown");
    }

    public ScreenConfig(Minecraft minecraft, Screen screen) {
        this();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int posY = 40;
        for (TabConfig currentTab : TabConfig.values()) {
            this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft - 75, this.guiTop + posY, 70, 15, (Component)Component.m_237115_((String)currentTab.name()), pressable -> {
                this.switchTab(currentTab);
                this.deathList.active = false;
                this.equipmentList.active = false;
                this.effectList.active = false;
                this.miscList.active = false;
                switch (currentTab) {
                    case DEATH: {
                        this.deathList.active = true;
                        break;
                    }
                    case EQUIPMENT: {
                        this.equipmentList.active = true;
                        break;
                    }
                    case EFFECT: {
                        this.effectList.active = true;
                        break;
                    }
                    case MISC: {
                        this.miscList.active = true;
                        break;
                    }
                }
            }, () -> currentTab == this.tab));
            posY += 16;
        }
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft - 75, this.guiTop + posY, 70, 15, (Component)Component.m_237113_((String)"SAVE"), pressable -> this.saveConfig(), () -> this.saveButtonHighlight));
        TabConfig.clear();
        this.deathList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 163, 14, this.deathOptions);
        this.m_7787_((GuiEventListener)this.deathList);
        TabConfig.DEATH.attach((AbstractWidget)this.deathList);
        this.equipmentList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 163, 14, this.equipmentOptions);
        this.m_7787_((GuiEventListener)this.equipmentList);
        TabConfig.EQUIPMENT.attach((AbstractWidget)this.equipmentList);
        this.miscList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 163, 14, this.miscOptions);
        this.m_7787_((GuiEventListener)this.miscList);
        TabConfig.MISC.attach((AbstractWidget)this.miscList);
        this.effectList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 107, 14, this.effectOptions);
        this.m_7787_((GuiEventListener)this.effectList);
        this.colorSliderHandler0.createWidget(x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 115, this.guiTop + 175, 80, 4);
        this.colorSliderHandler4.createWidget(x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 115, this.guiTop + 200, 80, 4);
        TabConfig.EFFECT.attach(this.effectList, this.colorSliderHandler0, this.colorSliderHandler4);
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new SliderButton(this.guiRight - 10 - 40, this.guiTop + 60, 40, 20, new ProgressOption("texture", 0.0, BlockGraveMarble.MarbleType.values().length - 1, 1.0f, Double.valueOf(this.playerPreference.getMarbleType().ordinal()), d -> this.playerPreference.setMarbleType(BlockGraveMarble.MarbleType.byId(d.intValue())), progressOption -> FontHelper.withFantasyFont((Component)Component.m_237115_((String)this.playerPreference.getMarbleType().m_7912_())), mc -> List.of()), Collections.emptyList()){

            @Override
            protected void m_5697_() {
                super.m_5697_();
                ScreenConfig.this.isDirty = true;
            }
        }));
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> {
            this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getPrevious());
            this.isDirty = true;
        }, true)));
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> {
            this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getNext());
            this.isDirty = true;
        }, true)));
        this.colorSliderHandler1.createWidget(x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 25, this.guiTop + 67, 40, 4);
        this.colorSliderHandler2.createWidget(x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 25, this.guiTop + 97, 40, 4);
        this.colorSliderHandler3.createWidget(x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 25, this.guiTop + 131, 40, 4);
        TabConfig.PLATE.attach(this.colorSliderHandler1, this.colorSliderHandler2, this.colorSliderHandler3);
        TabConfig.hideAll();
        this.tab.show();
    }

    private void switchTab(TabConfig tab) {
        if (this.tab != tab) {
            this.tab.hide();
            this.tab = tab;
            this.tab.show();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isDirty) {
            this.isDirty = false;
            this.saveButtonHighlight = this.getConfigState(false).isChanged();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 5, this.guiRight - 5, this.guiTop + 20 + 9, 0x55000000);
        FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, this.f_96539_, this.halfWidth, this.guiTop + 14, -1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tab) {
            case GRAVE: {
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)LangKey.MESSAGE_CHOOSE_FAVORITE_GRAVE.getText(new Object[0]), this.halfWidth, this.guiTop + 46, -1);
                ItemStack stack = new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)this.playerPreference.getFavoriteGrave()));
                ItemBlockGrave.setModelTexture(stack, this.playerPreference.getMarbleType().ordinal());
                Component displayName = stack.m_41611_();
                EngravableHelper.setEngravedName(stack, this.nameToDisplay);
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, displayName, this.halfWidth, this.guiBottom - 45, -1);
                guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 35, this.guiRight - 5, this.guiBottom - 32, 0x55000000);
                Helper.renderStackInGui(stack, this.guiLeft + 80, this.guiTop + 75, 6.0f, true);
                break;
            }
            case PLATE: {
                guiGraphics.m_280163_(tablet, this.guiLeft + 61, this.guiTop + 36, 0.0f, 0.0f, 154, 154, 154, 154);
                int textPos = this.halfWidth + 24;
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)LangKey.MESSAGE_RIP.getText(new Object[0]), textPos, this.guiTop + 70, this.colorSliderHandler1.getColor());
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)Component.m_237113_((String)this.nameToDisplay), textPos, this.guiTop + 100, this.colorSliderHandler2.getColor());
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)LangKey.MESSAGE_CONFIG_GRAVE_MESSAGE_1.getText(new Object[0]).m_130940_(ChatFormatting.ITALIC), textPos, this.guiTop + 130, this.colorSliderHandler3.getColor());
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)LangKey.MESSAGE_CONFIG_GRAVE_MESSAGE_2.getText(new Object[0]).m_130940_(ChatFormatting.ITALIC), textPos, this.guiTop + 140, this.colorSliderHandler3.getColor());
                break;
            }
            case DEATH: {
                Objects.requireNonNull(this);
                guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 35, this.guiLeft + 230 - 5, this.guiTop + 224, 0x55000000);
                this.deathList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                break;
            }
            case EQUIPMENT: {
                Objects.requireNonNull(this);
                guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 35, this.guiLeft + 230 - 5, this.guiTop + 224, 0x55000000);
                this.equipmentList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                break;
            }
            case MISC: {
                Objects.requireNonNull(this);
                guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 35, this.guiLeft + 230 - 5, this.guiTop + 224, 0x55000000);
                this.miscList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                break;
            }
            case EFFECT: {
                Objects.requireNonNull(this);
                guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 35, this.guiLeft + 230 - 5, this.guiTop + 224, 0x55000000);
                this.effectList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, this.colorSliderHandler0.getTitle(), this.guiLeft + 65, this.guiTop + 179, this.colorSliderHandler0.getColor());
                FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, this.colorSliderHandler4.getTitle(), this.guiLeft + 65, this.guiTop + 204, this.colorSliderHandler4.getColor());
            }
        }
    }

    private ConfigState getConfigState(boolean update) {
        if (!update) {
            return this.playerPreference.hasChangedFromConfig() || this.config_changed_predics.stream().anyMatch(p -> p.test(false)) ? ConfigState.CHANGED : ConfigState.UNCHANGED;
        }
        long countChanged = this.config_changed_predics.stream().filter(p -> p.test(true)).count();
        boolean requirePacket = this.playerPreference.hasChangedFromConfig();
        if (requirePacket) {
            this.playerPreference.updateClientConfig();
        }
        return requirePacket ? ConfigState.REQUIRED_PACKET : (countChanged > 0L ? ConfigState.CHANGED : ConfigState.UNCHANGED);
    }

    private void saveConfig() {
        ConfigState result;
        if (this.saveButtonHighlight && (result = this.getConfigState(true)).isChanged()) {
            ConfigTombstone.CLIENT_SPEC.save();
            if (result.requirePacket()) {
                ModTombstone.PROXY.markConfigDirty();
            }
        }
        this.m_7379_();
    }

    private <T> boolean checkConfig(ForgeConfigSpec.ConfigValue<T> config, T newValue, boolean update) {
        if (!newValue.equals(config.get())) {
            if (update) {
                config.set(newValue);
            }
            return true;
        }
        return false;
    }

    static enum TabConfig implements IHideable
    {
        GRAVE,
        PLATE,
        DEATH,
        EQUIPMENT,
        EFFECT,
        MISC;

        final List<IHideable> hideables = new ArrayList<IHideable>();

        void attach(IHideable ... theHideables) {
            this.hideables.addAll(Arrays.asList(theHideables));
        }

        void attach(final AbstractWidget button) {
            this.hideables.add(new IHideable(){

                @Override
                public void show() {
                    button.f_93624_ = true;
                    button.f_93623_ = true;
                }

                @Override
                public void hide() {
                    button.f_93624_ = false;
                    button.f_93623_ = false;
                }
            });
        }

        @Override
        public void show() {
            for (IHideable hideable : this.hideables) {
                hideable.show();
            }
        }

        @Override
        public void hide() {
            for (IHideable hideable : this.hideables) {
                hideable.hide();
            }
        }

        static void hideAll() {
            for (TabConfig tab : TabConfig.values()) {
                tab.hide();
            }
        }

        static void clear() {
            for (TabConfig tab : TabConfig.values()) {
                tab.hideables.clear();
            }
        }
    }

    public static interface IHideable {
        public void show();

        public void hide();
    }

    static enum ConfigState {
        UNCHANGED,
        CHANGED,
        REQUIRED_PACKET;


        boolean isChanged() {
            return this != UNCHANGED;
        }

        boolean requirePacket() {
            return this == REQUIRED_PACKET;
        }
    }
}

