/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenCompendium
extends TBScreen {
    private CompendiumData currentInfo;
    @Nullable
    private CompendiumData.CompendiumLabel hoveredInfo = null;
    private int currentPage = 0;
    private Button previousPage;
    private Button nextPage;
    private Button showRecipe;
    private DisplayType displayType = DisplayType.DESCRIPTION;
    private long delay = 0L;

    ScreenCompendium() {
        this(CompendiumData.CompendiumLabel.COMPENDIUM);
    }

    public ScreenCompendium(CompendiumData.CompendiumLabel currentInfo) {
        super((Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]));
        this.currentInfo = CompendiumData.getInfo(currentInfo);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo.isIndex()) {
                this.getThePlayer().m_6915_();
            } else {
                this.updateInfoAndButtons(CompendiumData.CompendiumLabel.COMPENDIUM);
            }
        }));
        this.previousPage = new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> this.changePage(this.currentPage - 1), true);
        this.m_142416_((GuiEventListener)this.previousPage);
        this.nextPage = new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> this.changePage(this.currentPage + 1), true);
        this.m_142416_((GuiEventListener)this.nextPage);
        Objects.requireNonNull(this);
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 230 / 4 - 35, this.guiTop + 34, 70, 15, (Component)LangKey.MESSAGE_DESCRIPTION.getText(new Object[0]), pressable -> {
            if (this.displayType != DisplayType.DESCRIPTION) {
                this.displayType = DisplayType.DESCRIPTION;
                this.updateButtons();
            }
        }, () -> this.displayType == DisplayType.DESCRIPTION));
        Objects.requireNonNull(this);
        this.showRecipe = new CustomButton(this.halfWidth + 230 / 4 - 35, this.guiTop + 34, 70, 15, (Component)LangKey.MESSAGE_RECIPE.getText(new Object[0]), pressable -> {
            if (this.displayType != DisplayType.RECIPE) {
                this.displayType = DisplayType.RECIPE;
                this.updateButtons();
            }
        }, () -> this.displayType == DisplayType.RECIPE);
        this.m_142416_((GuiEventListener)this.showRecipe);
        Objects.requireNonNull(this);
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft + 230 + 5, this.guiTop + 20, 90, 11, (Component)Component.m_237113_((String)"Support Corail 31"), pressable -> {
            long worldTick;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && this.delay <= (worldTick = TimeHelper.worldTicks((Level)Minecraft.m_91087_().f_91073_))) {
                try {
                    this.delay = worldTick + 100L;
                    Util.m_137581_().m_137648_(new URI("https://www.patreon.com/Corail31"));
                }
                catch (Throwable t) {
                    pressable.f_93623_ = false;
                }
            }
        }, () -> true));
        this.updateButtons();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.updateInfoAndButtons(this.hoveredInfo);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private void changePage(int pageNum) {
        if (pageNum >= 0 && pageNum < this.currentInfo.getPageMax()) {
            this.currentPage = pageNum;
            this.updateButtons();
        }
    }

    private void updateInfoAndButtons(CompendiumData.CompendiumLabel info) {
        this.currentInfo = CompendiumData.getInfo(info);
        this.currentPage = 0;
        this.displayType = DisplayType.DESCRIPTION;
        this.updateButtons();
    }

    private void updateButtons() {
        this.previousPage.f_93624_ = this.displayType == DisplayType.DESCRIPTION && this.currentPage > 0;
        this.previousPage.f_93623_ = this.previousPage.f_93624_;
        this.nextPage.f_93624_ = this.displayType == DisplayType.DESCRIPTION && this.currentPage < this.currentInfo.getPageMax() - 1;
        this.nextPage.f_93623_ = this.nextPage.f_93624_;
        this.showRecipe.f_93624_ = !this.currentInfo.getRecipes().isEmpty();
        this.showRecipe.f_93623_ = this.showRecipe.f_93624_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 5, this.guiLeft + 230 - 5, this.guiTop + 20 + 9, 0x55000000);
        FontHelper.drawCentered(guiGraphics, this.f_96547_, this.currentInfo.getTitle(), (float)this.halfWidth, (float)(this.guiTop + 15), -1);
        if (!this.currentInfo.isIndex()) {
            MutableComponent mutableComponent = Component.m_237113_((String)(this.currentPage + 1 + "/" + this.currentInfo.getPageMax()));
            Objects.requireNonNull(this);
            FontHelper.drawFantasy(guiGraphics, this.f_96547_, (Component)mutableComponent, this.guiLeft + 230 - 30, this.guiTop + 8, -1);
        }
        if (!this.currentInfo.getIcon().m_41619_()) {
            guiGraphics.m_280509_(this.guiLeft + 8, this.guiTop + 8, this.guiLeft + 26, this.guiTop + 26, 0x10FFFFFF);
            guiGraphics.m_280163_(FRAME, this.guiLeft + 7, this.guiTop + 7, 0.0f, 0.0f, 21, 21, 21, 21);
            guiGraphics.m_280480_(this.currentInfo.getIcon(), this.guiLeft + 9, this.guiTop + 9);
        }
        if (this.displayType == DisplayType.RECIPE) {
            guiGraphics.m_280509_(this.guiLeft + 5, this.guiTop + 55, this.guiRight - 5, this.guiBottom + 119, 0x55000000);
            List<CompendiumData.CompendiumRecipe> recipes = this.currentInfo.getRecipes();
            for (int i = 0; i < Math.min(recipes.size(), 6); ++i) {
                CompendiumData.CompendiumRecipe recipe = recipes.get(i);
                recipe.render(guiGraphics, this.guiLeft + 20 + i % 3 * 70, this.guiTop + 65 + i / 3 * 70);
            }
        } else {
            this.drawDescription(guiGraphics);
        }
        Objects.requireNonNull(this);
        int minX = this.guiLeft + 230 + 5;
        int minY = this.guiTop + 40;
        this.hoveredInfo = null;
        for (CompendiumData.CompendiumLabel link : this.currentInfo.getLinks()) {
            int maxX = minX + this.f_96547_.m_92852_((FormattedText)link.getTitle());
            Objects.requireNonNull(this.f_96547_);
            int maxY = minY + 9;
            boolean isHovered = false;
            if (this.hoveredInfo == null && mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                this.hoveredInfo = link;
                isHovered = true;
            }
            guiGraphics.m_280430_(this.f_96547_, link.getTitle(), minX, minY + 1, isHovered ? -1875 : -1);
            minY = maxY + 1;
        }
    }

    private void drawDescription(GuiGraphics guiGraphics) {
        int minX = this.guiLeft + 10;
        int minY = this.guiTop + 60;
        List<FormattedCharSequence> lines = this.currentInfo.getPage(this.currentPage);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280509_(minX - 5, minY - 5, this.guiLeft + 230 - 5, minY + 5 + (9 + 1) * lines.size(), 0x55000000);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280648_(this.f_96547_, line, minX, minY + 2 + i * (9 + 1), -1);
        }
    }

    static enum DisplayType {
        DESCRIPTION,
        RECIPE;

    }
}

