/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public class WololoSpellGoal
extends SpellUseGoal {
    protected final DyeColor dyeColor;
    protected final TargetingConditions wololoTargeting;

    public WololoSpellGoal(PathfinderMob caster, DyeColor dyeColor) {
        super(caster);
        this.dyeColor = dyeColor;
        this.wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(e -> ((Sheep)e).m_29874_() != this.dyeColor);
    }

    @Override
    public boolean m_8036_() {
        List list;
        if (super.m_8036_() && this.caster.m_5448_() == null && !(list = this.caster.m_9236_().m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)this.caster, this.caster.m_20191_().m_82377_(16.0, 4.0, 16.0))).isEmpty()) {
            EntityHelper.setSpecialTargetForSpell(this.caster, (Entity)list.get(Helper.RANDOM.nextInt(list.size())));
            return true;
        }
        return false;
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.caster.m_5448_() == null;
    }

    @Override
    protected void performSpellCasting() {
        EntityHelper.getSpecialTargetForSpell(this.caster).filter(Sheep.class::isInstance).map(Sheep.class::cast).ifPresent(sheep -> {
            sheep.m_29855_(this.dyeColor);
            EntityHelper.getServantOwner((Entity)this.caster).ifPresent(owner -> ModTriggers.wololo.get(this.dyeColor).trigger((ServerPlayer)owner));
        });
    }

    @Override
    protected int getCastWarmupTime() {
        return 80;
    }

    @Override
    protected int getCastingTime() {
        return 100;
    }

    @Override
    protected int getCastingInterval() {
        return 400;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.f_11869_;
    }

    @Override
    protected int getSpellColor() {
        return 3178592;
    }
}

